% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardModels.R
\name{lc}
\alias{lc}
\title{Create a Lee-Carter model}
\usage{
lc(link = c("log", "logit"), const = c("sum", "last", "first"))
}
\arguments{
\item{link}{defines the link function and random component associated with 
the mortality model. \code{"log"} would assume that deaths follow a 
Poisson distribution and use a log link while \code{"logit"} would assume 
that deaths follow a Binomial distribution and a logit link.}

\item{const}{defines the constraint to impose to the period index of the
model to ensure identifiability. The alternatives are 
\code{"sum"}(default),  \code{"last"} and \code{"first"} which apply 
constraints \eqn{\sum_t\kappa_t = 0}, \eqn{\kappa_n = 0} and 
\eqn{\kappa_1 = 0}, respectively.}
}
\value{
An object of class \code{"StMoMo"}.
}
\description{
Utility function to initialise a \code{StMoMo} object representing a 
Lee-Carter model.
}
\details{
The created model is either a log-Poisson (see Brouhns et al (2002)) or a 
logit-Binomial version of the Lee-Carter model which has predictor structure   
\deqn{\eta_{xt} = \alpha_x + \beta_x\kappa_t.}
To ensure identifiability one of the  following constraints is imposed
\deqn{\sum_t\kappa_t = 0,\,\kappa_1 = 0,\, \kappa_n = 0}
depending on the value of \code{const}, and
\deqn{\sum_x\beta_x = 1.}
}
\examples{

#sum(kt) = 0 and log link
LC1 <- lc()
LCfit1<-fit(LC1, Dxt = EWMaleData$Dxt,Ext = EWMaleData$Ext, 
            ages = EWMaleData$ages, years = EWMaleData$years,
            ages.fit = 55:89)
plot(LCfit1)

#kt[1] = 0 and log link
LC2 <- lc(const = "first")
LCfit2<-fit(LC2, Dxt = EWMaleData$Dxt,Ext = EWMaleData$Ext, 
            ages = EWMaleData$ages, years = EWMaleData$years,
            ages.fit = 55:89)
plot(LCfit2)

#kt[n] = 0 and logit link
LC3 <- lc("logit", "last")
LCfit3<-fit(LC3, Dxt = EWMaleData$Dxt,Ext = EWMaleData$Ext, 
            ages = EWMaleData$ages, years = EWMaleData$years,
            ages.fit = 55:89)
plot(LCfit3)

}
\references{
Brouhns, N., Denuit, M., & Vermunt, J. K. (2002). A Poisson log-bilinear 
regression approach to the construction of projected lifetables.
 Insurance: Mathematics and Economics, 31(3), 373-393.

Lee, R. D., & Carter, L. R. (1992). Modeling and forecasting U.S. mortality. 
Journal of the American Statistical Association, 87(419), 659-671.
}
\seealso{
\code{\link{StMoMo}}
}

