% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iarima.R
\name{forecast.iarima}
\alias{forecast.iarima}
\title{Forecast independent arima series}
\usage{
\method{forecast}{iarima}(object, h = 10, level = c(80, 95), fan = FALSE,
  ...)
}
\arguments{
\item{object}{an object of class \code{"iarima"}.}

\item{h}{Number of periods for forecasting.}

\item{level}{confidence level for prediction intervals.}

\item{fan}{if \code{TRUE}, level is set to \code{seq(50, 99, by = 1)}. 
This is suitable for fan plots.}

\item{...}{other arguments.}
}
\value{
An object of class \code{"iarimaForecast"} with components:
\item{model}{a list containing information about the fitted arima models.}
\item{mean}{ array with the central forecast.}
\item{lower}{ three dimensional array with lower limits for prediction 
 intervals.}
\item{upper}{ three dimensional array with upper limits for prediction 
 intervals.}
 \item{level}{ the confidence values associated with the prediction 
 intervals.}
 @export
}
\description{
Returns forecasts and other information for a group of
independent arima series.
}
