#ifndef STAN_LANG_GRAMMARS_STATEMENT_2_GRAMMAR_HPP
#define STAN_LANG_GRAMMARS_STATEMENT_2_GRAMMAR_HPP

#include <boost/spirit/include/qi.hpp>

#include <stan/lang/ast.hpp>
#include <stan/lang/grammars/whitespace_grammar.hpp>
#include <stan/lang/grammars/expression_grammar.hpp>

#include <string>
#include <sstream>
#include <vector>

namespace stan {
  namespace lang {

    template <typename Iterator>
    struct statement_grammar;

    template <typename Iterator>
    struct statement_2_grammar
      : boost::spirit::qi::grammar<Iterator,
                                   statement(bool, var_origin, bool),
                                   whitespace_grammar<Iterator> > {
      statement_2_grammar(variable_map& var_map,
                          std::stringstream& error_msgs,
                          statement_grammar<Iterator>& sg);

      // global info for parses
      variable_map& var_map_;
      std::stringstream& error_msgs_;

      // grammars
      expression_grammar<Iterator> expression_g;
      statement_grammar<Iterator>& statement_g;

      // rules

      boost::spirit::qi::rule<Iterator,
                              conditional_statement(bool, var_origin, bool),
                              whitespace_grammar<Iterator> >
      conditional_statement_r;


      boost::spirit::qi::rule<Iterator,
                              statement(bool, var_origin, bool),
                              whitespace_grammar<Iterator> >
      statement_2_r;
    };

  }
}
#endif
