% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\title{Area under curve of predicted binary response}
\usage{
auc(y, yhat)
}
\arguments{
\item{y}{actual binary response}

\item{yhat}{predicted probabilities corresponding to the actual binary response}
}
\value{
area under the ROC curve
}
\description{
Takes in actual binary response and predicted probabilities, and returns auc value
}
\details{
Area under the receiver operating characteristic (ROC) curve is the most sought after
 criteria for judging how good model predictions are.

 \code{auc} function calculates the true positive rates (TPR) and false positive
 rates (FPR) for each cutoff from 0.01 to 1 and calculates the area using trapezoidal
 approximation. A ROC curve is also generated.
}
\examples{
# A 'data.frame' with y and yhat
df <- data.frame(y = c(1, 0, 1, 1, 0, 0, 1, 0, 1, 0),
                 yhat = c(0.86, 0.23, 0.65, 0.92, 0.37, 0.45, 0.72, 0.19, 0.92, 0.50))

# AUC figure
AUC <- auc(y = df[, 'y'], yhat = df[, 'yhat'])
}
\author{
Akash Jain
}
\seealso{
\code{\link{accuracy}}, \code{\link{ks}}, \code{\link{iv}}, \code{\link{gini}}, \code{\link{splitdata}}
}

