% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mwdbm.R
\name{mwdbm}
\alias{mwdbm}
\title{Fit a mixture weighted distance-based model}
\usage{
mwdbm(dset, G, dset.agg = TRUE, dtype = "Kendall", noise = FALSE,
  iter = 100)
}
\arguments{
\item{dset}{data set of complete rankings}

\item{G}{number of clusters}

\item{dset.agg}{whether the data set is in the aggregated form
(default as FALSE)}

\item{dtype}{type of the weighted distance measure
Kendall or K(default) : "Weighted Kendall's tau", SqrtSpearman
or SS : "Square root of weighted Spearman", Spearman or S :
"Weighted Spearman", Footrule or F : "Weighted Spearman's
footrule"}

\item{noise}{whether a noise cluster is contained (default as FALSE)}

\item{iter}{number of iterations of the EM algorithm (default as 100)}
}
\value{
a list of the fitting result, containing the following objects:
        $clusterNum number of clusters (excluding the noise)
        $dtype type of the distance measure
        $noise whether a noise cluster is contained
        $iterNum actual number of iterations of the EM algorithm
        $convergence whether the complete-data loglikelihood converges
        $clusterProb probability of each cluster
        $modalRank modal rankings
        $weight weight vectors for clusters
        $trueLoglik the true loglikelihood by the fitted model
        $squaredPearsonStat the sum of squares of Pearson residuals
}
\description{
This function computes fitting of mixture weighted distance-based
model for the given data set of complete rankings.
}
\examples{
data(Croon)
# Time comu
# mwdbm(Croon, 3)
}
\author{
Yumin Zhang <zymneo@gmail.com>
}

