% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting_functions.R
\name{fit.mult.model}
\alias{fit.mult.model}
\title{Fit the multiplicative model to data}
\usage{
fit.mult.model(geno.matrix, fit.matrix, wts = c(2, 1))
}
\arguments{
\item{geno.matrix}{Genotype matrix generated in
\code{\link{generate.geno.matrix}} or read in}

\item{fit.matrix}{Fitness matrix generated in
\code{\link{sim.mult.data}} or read in}

\item{wts}{Vector of weights to weight genotypes by. Used when
\code{\link{generate.geno.weight.matrix}} is called (see that function).
Default is \code{c(2,1)}.}
}
\value{
List:\cr
 [[1]] \code{s.hats} are the estimated selection
  coefficients;\cr
 [[2]] \code{R2} is proportion of fitness variation
  explained by model. Does not include wild type in calculation.\cr
 [[3]] \code{sig.hat} is estimate of sigma \cr
 [[4]] \code{logLike} is log-likelihood of the data under the fitted model. \cr
 [[5]] \code{regression.results} List of results when regressing effects of mutations against the background fitness
of mutations (see details). [[1]] \code{p.vals} gives p-value of each mutation, [[2]] \code{lm.intercepts} gives
estimated intercept for mutation, [[3]] \code{lm.slopes} gives slope for each mutation, [[4]] \code{P} is the
sum of the log of p-values. This is the summary statistic. [[5]] \code{fitness.of.backs} Matrix with fitness of backgrounds when each mutation (columns) is added to each genotype (rows).
[[6]] \code{effects.matrix} Matrix with fitness effect when given mutation (column) is added to given create genotype (row).
}
\description{
Fit the multiplicative model to data
}
\details{
\code{wts}:  The coefficient estimates are obtained by weighted comparisons. The
  default is to give wild type to single mutation genotype comparisons twice the weight
  as all other comparisons based on the assumption that wild type is know
  with much lower error than the other genotypes (actually it is assumed to be known with no error).
  @seealso \code{\link{fit.stick.model.given.d}}
  @examples
  fit.mult.model(
   data[,seq(1, length(Khan.data[1,])-1)],
   as.matrix(data[,(length(Khan.data[1,]))]),
   c(2,1))
}

