% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_fnxs.R
\name{sim.add.data}
\alias{sim.add.data}
\title{Simulate data under additive model.}
\usage{
sim.add.data(n.muts, addcoes, sigma, w.wt, geno.matrix)
}
\arguments{
\item{n.muts}{Number of mutations.}

\item{addcoes}{Vector of additive effect for each mutation}

\item{sigma}{Noise to add to expectations}

\item{w.wt}{Fitness of the wildtype}

\item{geno.matrix}{Specifies which genotypes are simulated.}
}
\value{
List:\cr
[[1]] \code{fit.matrix} is matrix with (simulated) observed data \cr
[[2]] \code{fit.matrix.exp} is same matrix without error
}
\description{
Simulate data under additive model.
}
\details{
Function takes additive effects (\code{addcoes}) and generates the expected
fitness values for each genotype. This set of expected values is returned as \code{fit.matrix.exp}.
Then it adds normal error to them to produce the "observed" data (\code{fit.matrix}).
}
\examples{
addcoes <- rep(0.3, 3)
geno.matrix <- generate.geno.matrix(3)
sim.add.data(3,addcoes,0.1,1,geno.matrix)
}

