% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotHistogram.R
\name{plotHistogram}
\alias{plotHistogram}
\title{Plot StochKit2R simulation histogram output data}
\usage{
plotHistogram(histogramFileName)
}
\arguments{
\item{histogramFileName}{Character string with path to StochKit2 histogram output file. IMPORTANT: histogram file names have format hist_<species index>_<time point>.dat, where species index STARTS AT 0 (not 1!)}
}
\value{
The ggplot object
}
\description{
\code{plotHistogram} Plots histogram of data stored in StochKit2R histogram output file \code{histogramFileName}. IMPORTANT: histogram file names have format hist_<species index>_<time point>.dat, where species index STARTS AT 0 (not 1!)
}
\examples{
\dontrun{
#example using included dimer_decay.xml file
model <- system.file("dimer_decay.xml",package="StochKit2R")
#output written to ex_out directory (created in current working directory)
ssa(model,"ex_out",10,100,20,keepHistograms=TRUE,force=TRUE)
#plot the histogram for species 2 at time point 5
#IMPORTANT: histogram file names have format:
#hist_<species index>_<time point>.dat, where species index STARTS AT 0
plotHistogram("ex_out/histograms/hist_1_5.dat")
}
}

