% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStorms.R
\name{plotStorms}
\alias{plotStorms}
\title{Plotting storm track data}
\usage{
plotStorms(
  sts,
  names = NULL,
  category = NULL,
  xlim = NULL,
  ylim = NULL,
  labels = FALSE,
  by = 8,
  pos = 3,
  legends = "topleft",
  loi = TRUE
)
}
\arguments{
\item{sts}{\code{StormsList} object}

\item{names}{character vector. Name(s) of the storm(s) in capital letters.
If \code{names = NULL} (default setting), all storms are plotted.}

\item{category}{numeric vector. Category of storms to be plotted in the Saffir-Simpson hurricane wind scale.
Can be a single category or a range of categories among:
\itemize{
\item -1, for tropical depression,
\item 0, for tropical storms,
\item 1, for category 1 tropical cyclone,
\item 2, for category 2 tropical cyclone,
\item 3, for category 3 tropical cyclone,
\item 4, for category 4 tropical cyclone, or
\item 5, for category 5 tropical cyclone.
}
If \code{category=NULL} (default setting), all storms are plotted.}

\item{xlim}{numeric vector. The x limits of the plot.}

\item{ylim}{numeric vector. The y limits of the plot.}

\item{labels}{logical. Whether (TRUE) or not (FALSE, default setting) to add labels with the name
of the storm and the indices and ISO times of the observation.}

\item{by}{numeric. If \code{labels=TRUE}, defines the frequency at which labels are plotted.
Default value is set to \code{8} which corresponds to a 24h (or 48h) time interval between the labelled observations
when observations are made every 3 (or 6) hours.}

\item{pos}{numeric. If \code{labels=TRUE}, defines the position of the labels, \code{1} (above the observation),
\code{2} (on the left), \code{3} (below, default setting), and \code{4} (on the right).}

\item{legends}{character. Indicates where to plot the legend, \code{"topright"}, \code{"topleft"} (default setting),
\code{"bottomleft"}, \code{"bottomright"}, or \code{"none"} (legend not plotted).}

\item{loi}{logical. Whether (TRUE, default setting) or not (FALSE) to plot the
extent of the buffered location of interest on the map.}
}
\value{
A plot of the storm track data.
}
\description{
This \code{plotStorms()} function allows plotting storm track data stored in a \code{StormsList} object.
}
\examples{
#' #Creating a stormsDataset
\donttest{
dev.off()
sds <- defStormsDataset()

# Getting storm track data for tropical cyclone Pam (2015)
pam <- defStormsList(sds = sds, loi = "Vanuatu", names = "PAM")

# Plotting Pam over Vanuatu with labels every 24h
plotStorms(pam, labels = TRUE)

# Plotting Pam over Vanuatu with labels every 6h on the right side of the observations
plotStorms(pam, labels = TRUE, by = 2, pos = 4)
}
}
