% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homogenise.R
\name{homogenise}
\alias{homogenise}
\alias{homogenize}
\title{Homogenise a list}
\usage{
homogenise(i = NULL, n = NULL, l = list(), cycle = TRUE)

homogenize(i = NULL, l = list(), cycle = TRUE)
}
\arguments{
\item{i}{reference object of length n}

\item{n}{length to reach (is overriden by i)}

\item{l}{list for each element to be repeated to have a length n. These
elements have to be integers, numerics or characters.}

\item{cycle}{whether to recycle the elements or to only allow elements of
length 1 or n}
}
\value{
A list identical to the one initially provided, with elements length
homogenized to i
}
\description{
Takes each element of a list and repeats each one so they
have the same length. This function is designed to be
integrated in another function and clean its arguments.
}
\examples{
i     <- rep(1:4, 2)

l <- list(a = c(1,2,3),
          b = "R",
          d = 1:100,
          e = c("a", "b"))

homogenise(i = i, l = l)

homogenise(n = 10, l = l)

}
\seealso{
\code{\link{merge_list}}
}
