% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/planepoints.R
\name{planepoints}
\alias{planepoints}
\title{Describes planes by points}
\usage{
planepoints(strike, dip, quadrant = NA, inverted = NA)
}
\arguments{
\item{strike}{strike of the data; it is the angle from the north of
the horizontal line of the plane. It is corrected by dipfix().}

\item{dip}{dip of the data; it is the angle from the horizontal taken
on the line of the plane perpendicular to the one of the strike. It is
corrected by dipfix().}

\item{quadrant}{the quadrant where the plane dips downward. Accepted
values are NA, 'N', 'S', 'W' or 'E' (lower- or uppercase alike) for
correction by dipfix().}

\item{inverted}{whether the plane is inverted or not. The default is
NA, it assumes that no bed is inverted.}
}
\value{
a list of x, y and z declinations and inclinations (dec and inc), and
a rotation magnitude
}
\description{
Gives the coordinates (dec and inc) of three perpendicular
directions to describe planes.
}
\details{
The directions are x for dip-direction line (direction of maximum
downward dip), y for the horizontal line, z for the upper pole; additionally
a magnitude is given to use y as a rotation axis to get the plane back at the
horizontal. If the plane is inverted, y, z and mag will be changed,
accordingly, with a rotation of 180° around x for y and z.
}
\examples{
strike   <- c(-60, 180,20)
dip      <- c(-60,20,-45)
quadrant <- c("N","W",NA)
inverted <- c(FALSE,FALSE,TRUE)

res <- planepoints(strike,dip,quadrant,inverted)

deci <- c(res$x$dec, res$y$dec, res$z$dec)
inci <- c(res$x$inc, res$y$inc, res$z$inc)

earnet()

earplanes(strike,dip,quadrant,hsphere = "l")
earpoints(deci,inci)

}
