% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earnet.R
\name{earnet}
\alias{earnet}
\title{Draws an equal area stereonet}
\usage{
earnet(xlim = c(-1.1, 1.1), ylim = c(-1.1, 1.1), ndiv = 10,
  col = gray(0.7), border = "black", lwd = 1, orientation = TRUE,
  xh = "WE", add = FALSE)
}
\arguments{
\item{xlim, ylim}{the x and y minimal limits. The actual limits can
change to keep a x/y ratio of 1}

\item{ndiv}{the number of intervals between each line crossing}

\item{col}{the colour of the net}

\item{border}{the colour of the border and crosshair}

\item{lwd}{the line width}

\item{orientation}{logical, whether to add captions indicating the
orientation of the plot.}

\item{xh}{orientation of the x axis: can be 'WE' or 'SN'. Has to be
provided to earplanes and earpoints}

\item{add}{logical, whether to add the circle to an existing plot}
}
\description{
Draws Equal Area Stereo-Net. Lambert azimuthal Equal-Area
(Schmidt) from Snyder p. 185-186 (modified from RFOC package)
}
\examples{
par(mfrow = c(1,2))
earnet()
earnet(xh  = "SN")
par(mfrow = c(1,1))
}
\references{
Snyder, John P., 1987, Map Projections-a working manual,
USGS-Professional Paper, 383p. pages 185-186, RFOC package
}
\seealso{
\code{\link{earinc}}, \code{\link{earplanes}},
\code{\link{earpoints}} and \code{\link{zijderveld}}
}
