% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTrial.R
\name{SimTrial}
\alias{SimTrial}
\title{Simulates a Sub-TITE trial design}
\usage{
SimTrial(nSims, Nmax, T1, Target, Dose, DoseStart, Upper, Accrue, groupprob,
  Hyper, Family, Param1, Param2, VarInt, VarSlope)
}
\arguments{
\item{nSims}{Number of Trials to Simulate.}

\item{Nmax}{Maximum Number of Patients to enroll in the trial.}

\item{T1}{Reference time for toxicity.}

\item{Target}{Target cumulative toxicity probability (or subgroup specific vector) at time T1.}

\item{Dose}{Standardized vector of doses to try.}

\item{DoseStart}{Dose (or vector of Doses) to enroll the first patient in each subgroup at.}

\item{Upper}{Cutoff values used to determine if accrual in a subgroup should be suspended.}

\item{Accrue}{Expected montly patient accrual rate.}

\item{groupprob}{Probability vector of subgroup assignment.}

\item{Hyper}{List of size 4 containing the prior mean of the baseline slope, the baseline intercept, and the prior mean vectors for group specific intercepts and slopes.}

\item{Family}{What distribution Family to simulate from. Options include: Exponential,Gamma, Lognormal, Uniform, Weibull.}

\item{Param1}{#Groups X #Doses Matrix containing the first parameter for each subgroup and dose. For the uniform distribution, this is the probability of toxicity in a given group.}

\item{Param2}{#Groups X #Doses Matrix containing the second parameter for each subgroup and dose for the Weibull, Gamma and Lognormal Distributions. This argument is not used for uniform and exponential distribution families.}

\item{VarInt}{Prior Variance of Intercept Parameters}

\item{VarSlope}{Prior Variance of Slope Parameters}
}
\value{
Returns a list with three simulation outputs: The vector of optimal doses chosen, the vector containing the doses administered in a trial and the group assignments of each patient in a simulated trial.
}
\description{
Simulates replicates from a Sub-TITE trial with user specified true toxicity time distributions for different doses and subgroups and returns average summary statistics of the trial.
}
\examples{
##Note: nSims  should be set larger than the example below.
nSims=1
##Specify reference toxicity time and target
T1=6
Target=.3
##Number of Groups
##Specify upper bound for determining if the lowest dose is too toxic in a subgroup
Upper=c(.95,.95)
##Maximum Sample Size
Nmax=40
##Standardized Dose Values and starting dose index
Dose=sort(rnorm(4))
DoseStart=1
##Hypermeans for linear terms
meanmu=2.21
meanslope=-.57
MeanInts = c(.46)
MeanSlopes = c(.04)
##Accrual Rate
Accrue=2
groupprob=c(.5,.5)
##Fill in Hyperparameter list for MCMC
Hyper=as.list(c(0,0,0,0))
Hyper[[1]]=meanmu
Hyper[[2]]=meanslope
Hyper[[3]]=MeanInts
Hyper[[4]]=MeanSlopes
Family="Uniform"
Param1 = matrix(c(.2,.3,.4,.5,.6,.1,.2,.3,.4,.5),byrow=TRUE,nrow=2)
Param2=Param1
VarInt=5
VarSlope=1
SimTrial(nSims,Nmax,T1,Target,Dose,DoseStart,
Upper,Accrue,groupprob,Hyper,Family,Param1,Param2,VarInt,VarSlope)
}
\references{
[1] Chapple and Thall (2017), Subgroup-specific dose finding in phase I clinical trials based on time to toxicity allowing adaptive subgroup combination
}
