% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-voc_corr.R
\name{voc.corr}
\alias{voc.corr}
\title{Correct Voc for Module Temperature}
\usage{
voc.corr(df)
}
\arguments{
\item{df}{A dataframe of IV curve data, containing an lnSun column generated
by the \code{\link{p_iv.week}} function.}
}
\value{
returns a list object of modeled Voc.
}
\description{
This method uses a physical model to correct Voc for the module
temperature. Since indoor Suns-Voc is conducted at a steady 25C,
a correction on the outdoor readings is necessary for meaningful
comparison.
}
\examples{
# subset data to first period
df_slice <- dplyr::filter(df_wbw, df_wbw$n_period == 1)
N_c <- 4 # true of the example data. N_c is the number of cells in series

df_slice <- dplyr::mutate(df_slice, T_K = .data$modt + 273.15,
                      lnSun = 1.38e-23/1.6e-19 * N_c * .data$T_K * log(.data$ishc),
                      T_lnIsc2 = .data$lnSun * log(.data$ishc),
                      exrs = as.numeric(.data$exrs),
                      expVoc = exp(-.data$vocc/.data$T_K) / .data$ishc,
                      I0 = (N_c * 1.38e-23 * .data$T_K) / (1.6e-19 * .data$ishc))

voc_mod <- voc.corr(df_slice)

}
