% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.ranger.R
\name{SL.ranger}
\alias{SL.ranger}
\title{SL wrapper for ranger}
\usage{
SL.ranger(Y, X, newX, family, obsWeights, num.trees = 500,
  mtry = floor(sqrt(ncol(X))), write.forest = TRUE,
  probability = family$family == "binomial",
  min.node.size = ifelse(family$family == "gaussian", 5, 1), replace = TRUE,
  sample.fraction = ifelse(replace, 1, 0.632), num.threads = 1,
  verbose = T, ...)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Training dataframe}

\item{newX}{Test dataframe}

\item{family}{Gaussian or binomial}

\item{obsWeights}{Observation-level weights}

\item{num.trees}{Number of trees.}

\item{mtry}{Number of variables to possibly split at in each node. Default is
the (rounded down) square root of the number variables.}

\item{write.forest}{Save ranger.forest object, required for prediction. Set
to FALSE to reduce memory usage if no prediction intended.}

\item{probability}{Grow a probability forest as in Malley et al. (2012).}

\item{min.node.size}{Minimal node size. Default 1 for classification, 5 for
regression, 3 for survival, and 10 for probability.}

\item{replace}{Sample with replacement.}

\item{sample.fraction}{Fraction of observations to sample. Default is 1 for
sampling with replacement and 0.632 for sampling without replacement.}

\item{num.threads}{Number of threads to use.}

\item{verbose}{If TRUE, display additional output during execution.}

\item{...}{Any additional arguments, not currently used.}
}
\description{
Ranger is a fast implementation of Random Forest (Breiman 2001)
  or recursive partitioning, particularly suited for high dimensional data.

Extending code by Eric Polley from the SuperLearnerExtra package.
}
\examples{

data(Boston, package = "MASS")
Y = Boston$medv
# Remove outcome from covariate dataframe.
X = Boston[, -14]

set.seed(1)

# Use only 2 CV folds to speed up example.
sl = SuperLearner(Y, X, family = gaussian(), cvControl = list(V = 2),
                 SL.library = c("SL.mean", "SL.ranger"))
sl

pred = predict(sl, X)
summary(pred$pred)

}
\references{
Breiman, L. (2001). Random forests. Machine learning 45:5-32.

Wright, M. N. & Ziegler, A. (2016). ranger: A Fast Implementation of Random
Forests for High Dimensional Data in C++ and R. Journal of Statistical
Software, in press. http://arxiv.org/abs/1508.04409.
}
\seealso{
\code{\link{SL.ranger}} \code{\link[ranger]{ranger}}
  \code{\link[ranger]{predict.ranger}}
}
