% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_analysis_copula.R
\name{constructor_ICA_estimator}
\alias{constructor_ICA_estimator}
\title{Function constructor to estimate the ICA given a set of sampled patient-level
treatment effects}
\usage{
constructor_ICA_estimator(endpoint_types, ICA_def)
}
\arguments{
\item{endpoint_types}{(character) vector with two elements indicating the
endpoint types: \code{"continuous"} or \code{"ordinal"}.}

\item{ICA_def}{function that takes the following arguments: \eqn{I(\Delta S;
  \Delta T)}, \eqn{\Delta S}, and \eqn{\Delta T}. It returns the ICA as a
function of these information-theoretic quantities.}
}
\value{
A function that estimates the user-defined definition of the ICA.
This function can be used as \code{ICA_estimator} in
\code{\link[=sensitivity_analysis_copula]{sensitivity_analysis_copula()}}.
}
\description{
The \code{\link[=constructor_ICA_estimator]{constructor_ICA_estimator()}} function returns a function the estimates
the ICA as a user-specified function of \eqn{I(\Delta S; \Delta T)},
\eqn{\Delta S}, and \eqn{\Delta T}.
}
