% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survMC.R
\name{survMC}
\alias{survMC}
\title{Survival analysis using Cox Proportional Hazards with MCMC.}
\usage{
survMC(m, n, chains, iter, data)
}
\arguments{
\item{m}{Starting column number from where variables of high dimensional data will get selected.}

\item{n}{Ending column number till where variables of high dimensional data will get selected.}

\item{chains}{Number of chains to be considered}

\item{iter}{Number of iterations to be applied}

\item{data}{High dimensional data having survival duration and event.}
}
\value{
survMCout Data set containing Posterior HR estimates and deviance values
}
\description{
Performs survival analysis using Cox Proportional Hazards with MCMC.
}
\details{
The survival columns of the data should be arranged as follows -
Death Death status=1 if died otherwise 0.
OS Survival duration measured as 'OS'
t.len Number of censored times
}
\examples{
\dontrun{
##
data(mcsurv)
survMC(4,8,2,10,mcsurv)
##
}
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R
and OpenBUGS. CRC Press.
}
\seealso{
survintMC
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
