% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survintMC.R
\name{survintMC}
\alias{survintMC}
\title{High dimensional survival analysis with interval censored data by MCMC}
\usage{
survintMC(m, n, Leftcensor, OS, Death, iter, data)
}
\arguments{
\item{m}{Starting column number from where variables of high dimensional data will get selected.}

\item{n}{Ending column number till where variables of high dimensional data will get selected.}

\item{Leftcensor}{"Variable/column name" containing the left censoring information.}

\item{OS}{"Variable/column name" containing survival duration event observations.}

\item{Death}{"Variable/column name" containing the survival event information. i.e. Death}

\item{iter}{Number of MCMC iterations.}

\item{data}{High dimensional data containing the Left censoring, Right censoring, Status and DEG observations.}
}
\value{
survintMCout A table containing HR and CI for respective covariates.
}
\description{
Performs survival analysis with MCMC on a data set by computing survival interval given left and right censoring time.
}
\details{
The survival columns of the data should be arranged as follows -
leftcensoring The column containing the left censoring information, must be named as 'Leftcensor'.
Rightcensor The column containing the right censoring information, must be named as 'Rightcensor' i.e. OS.
Death The column containing the death and alive information, must be names as 'Status'.
}
\examples{
\dontrun{
##
data(hnscc)
survintMC(7,11,Leftcensor="leftcensoring",OS="os",Death="death",6,hnscc)
##
}
}
\references{
Bogaerts, K., Komarek, A., & Lesaffre, E. (2017). Survival analysis
 with interval-censored data: A practical approach with examples in R, SAS,
 and BUGS. CRC Press.
}
\seealso{
survMC
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
