% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_forest_dataframe.R
\name{survival_forest}
\alias{survival_forest}
\title{Build a Survival Forest (Data Supplied as a Dataframe)}
\usage{
survival_forest(
  survival_outcome,
  numeric_predictor,
  factor_predictor,
  weights = NULL,
  data,
  significance = 0.05,
  min_weights = 50,
  missing = "omit",
  test_type = "univariate",
  cut_type = 0,
  nboot = 100,
  seed = 0
)
}
\arguments{
\item{survival_outcome}{a \code{Surv} object of right-censored outcomes. 
In \code{Surv(time,event)},
\code{time[i]} is the survival time of the ith sample.
\code{event[i]} is the survival event of the ith sample.}

\item{numeric_predictor}{a formula specifying the numeric predictors. 
As in \code{~x1+x2+x3}, the three numeric variables \code{x1}, \code{x2}, and \code{x3} are included as numeric predictors. 
\code{x1[i]}, \code{x2[i]}, and \code{x3[i]} are the predictors of the ith sample.}

\item{factor_predictor}{a formula specifying the numeric predictors. 
As in \code{~z1+z2+z3}, the three character variables \code{z1}, \code{z2}, and \code{z3} are included as factor predictors. 
\code{z1[i]}, \code{z2[i]}, and \code{z3[i]} are the predictors of the ith sample.}

\item{weights}{sample weights, a numeric vector. 
\code{weights[i]} is the weight of the ith sample.}

\item{data}{the dataframe that stores the outcome and predictor variables.
Variables in the global environment will be used if \code{data} is missing.}

\item{significance}{significance threshold, a numeric value. 
Stop the splitting algorithm when no splits give a p-value smaller than \code{significance}.}

\item{min_weights}{minimum weight threshold, a numeric value. 
The weights in a node are greater than \code{min_weights}.}

\item{missing}{a character value that specifies the handling of missing data. 
If \code{missing=="omit"}, samples with missing values in the splitting variables will be discarded.
If \code{missing=="majority"}, samples with missing values in the splitting variables will be assigned to the majority node.
If \code{missing=="weighted"}, samples with missing values in the splitting variables will be weighted by the weights of branch nodes.}

\item{test_type}{a character value that specifies the type of statistical tests.
If \code{test_type=="univariate"}, then it performs a log-rank test without p-value adjustments.
If \code{test_type} is in \code{p.adjust.methods}, i.e., one of holm, hochberg, hommel, bonferroni, BH, BY, or fdr, 
then the p-values will be adjusted using the corresponding method.}

\item{cut_type}{an integer value that specifies how to cut between two numeric values.
If \code{cut_type==0}, then cut at the ends.
If \code{cut_type==1}, then cut from the middle.
If \code{cut_type==2}, then cut randomly between the two values.}

\item{nboot}{an integer value that specifies the number of bootstrap replications.}

\item{seed}{an integer value that specifies the seed.}
}
\value{
A list containing the information of the survival forest fit.
}
\description{
The function 
\code{survival_forest} build a survival forest given the survival outcomes and predictors of numeric and factor variables.
}
\details{
Build a Survival Forest (Data Supplied as a Dataframe)
}
\examples{
\donttest{
library(survival)
a_survival_forest<-
  survival_forest(
    survival_outcome=Surv(time,status==2)~1,
    numeric_predictor=~age+ph.ecog+ph.karno+pat.karno+meal.cal,
    factor_predictor=~as.factor(sex),
    data=lung,nboot=20)
}
}
