\name{taglist}
\alias{print.taglist}
\alias{taglist}
\title{S3 class taglist}
\description{
Generating function and print method for S3 class \code{taglist}
}
\usage{
taglist(..., list = NULL, defname = "V")
\method{print}{taglist}(x, LineLength = getOption("width"), offset.start = 0,
              withFinalLineBreak = TRUE, first.print = NULL,
                          ErrorOrWarn = "warn", ...)
}
\arguments{
  \item{\dots}{arbitrary number of arguments in \code{taglist}, respectively,
               in \code{print.taglist}, further arguments to be passed to or
                from other methods.  They are ignored in this function.}

  \item{list}{list; to be prepended to the \code{\dots} argument; useful to
  take in predefined default lists;}
  \item{defname}{character; defaults to \code{"V"}; prefix of names given
  to a priori unnamed list elements; see below}
  \item{x}{an object of class \code{taglist}}
  \item{LineLength}{numeric; deafults to getOption("width"); number of characters per line;
                    i.e.; \code{print}
  will make a linebreak \emph{between} two tags before this number is
  reached; it will not break a tag, however, and only issue an error if
  this single tag is longer than \code{max(3*LineLength,getOption("width"))}. }
  \item{offset.start}{numeric; number of characters to indent in printing;}
  \item{withFinalLineBreak}{logical; shall there be a final line break;
                        defaults to \code{TRUE}.}
  \item{first.print}{character; something to be printed immediately before
  the first list item; defaulting to \code{NULL}.}
  \item{ErrorOrWarn}{shall we issue a warning (if partially matched to \code{"warn"}
                     or else an error}
  }

\details{
\code{taglist} is an S3 class inheriting from class \code{list}.
It requires all elements to be uniquely named. Objects of this
class can be generated by a call to the generating function
\code{taglist()}; there is a particular \code{print} method
for this class. The generating function
\code{taglist()} accepts an arbitrary number of (not necessarily named)
arguments and a list of (again not necessarily named) elements;
if in the arguments of \code{taglist()} some list items do not have a
name a priori, all of these get named in the order of appearance
as \var{<defname><position number in arglist>}.
}

\value{
\item{taglist}{an object of S3 class \code{taglist}}
\item{print.default}{\code{invisible()}}
}

\author{Peter Ruckdeschel \email{peter.ruckdeschel@uni-oldenburg.de}}
\examples{
 TL <- taglist("HA"=8,"JUI"=7,"butzi", list=list("HU"="AHAL","HA"="BETA","BUZ"))
 print(TL)
 print(TL, LineLength=10, first.print="myList=", offset.start=4,
           withFinalLineBreak = FALSE)
 }

\keyword{utilities}


