

test_that("ISL season 2 dataframe dims", {

  skip_on_cran() # due to risk of external resources failing

  file <- "https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/ISL/Season_2_2020/ISL_01112020_Budapest_Match_6.pdf"

  if(is_link_broken(file) == TRUE){
    warning("Link to external data is broken")
  } else {
  df <- swim_parse_ISL(
    read_results(file),
    splits = TRUE,
    relay_swimmers = TRUE)
  expect_equivalent(dim(df), c(324, 20)) # 324 is the normal number of rows, although there can be more depending on ties in the skins races
  } # 20 is the normal number of columns

})

test_that("ISL season 2 whole dataframe", {

  skip_on_cran() # due to risk of external resources failing

  file <- "https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/ISL/Season_2_2020/ISL_09112020_Budapest_Match_10.pdf"

  if(is_link_broken(file) == TRUE){
    warning("Link to external data is broken")
  } else {
    df_test <- file %>%
      read_results() %>%
      swim_parse_ISL(splits = TRUE, relay_swimmers = TRUE)

    df_standard <- structure(list(Place = c(1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4,
                                            5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1,
                                            2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6,
                                            7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3,
                                            4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8,
                                            1, 2, 3, 4, 5, 6, 7, NA, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4,
                                            5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1,
                                            2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6,
                                            7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3,
                                            4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8,
                                            1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5,
                                            6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2,
                                            3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7,
                                            8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4,
                                            5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1,
                                            2, 3, 4, 1, 2, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 1, 2), Lane = c(1,
                                                                                                               6, 2, 4, 5, 3, 7, 8, 5, 1, 6, 4, 7, 8, 2, 3, 5, 6, 2, 1, 7, 4,
                                                                                                               8, 3, 1, 5, 3, 4, 2, 7, 8, 6, 4, 5, 3, 1, 7, 6, 2, 8, 2, 4, 1,
                                                                                                               8, 6, 5, 3, 7, 4, 5, 1, 7, 2, 6, 8, 3, 5, 1, 8, 6, 2, 7, 3, 4,
                                                                                                               2, 1, 5, 3, 6, 4, 7, 8, 3, 7, 4, 1, 2, 6, 5, 8, 6, 4, 2, 1, 3,
                                                                                                               7, 5, 8, 7, 2, 8, 4, 6, 3, 1, 5, 6, 5, 4, 7, 8, 3, 2, 1, 5, 7,
                                                                                                               1, 4, 3, 6, 8, 2, 5, 4, 7, 2, 6, 1, 3, 8, 1, 4, 3, 5, 6, 7, 2,
                                                                                                               8, 5, 7, 6, 4, 3, 2, 1, 8, 7, 1, 4, 5, 3, 2, 8, 6, 5, 4, 1, 6,
                                                                                                               3, 2, 7, 8, 1, 7, 4, 5, 3, 8, 6, 2, 5, 6, 2, 1, 4, 8, 3, 7, 3,
                                                                                                               7, 4, 8, 6, 5, 2, 1, 3, 5, 1, 2, 8, 7, 6, 4, 5, 4, 2, 1, 8, 6,
                                                                                                               7, 3, 3, 2, 4, 5, 1, 6, 8, 7, 6, 5, 4, 2, 3, 1, 7, 8, 6, 5, 4,
                                                                                                               2, 3, 1, 8, 7, 3, 4, 6, 2, 7, 5, 1, 8, 2, 5, 3, 7, 8, 6, 4, 1,
                                                                                                               3, 2, 5, 1, 4, 7, 6, 8, 5, 6, 3, 2, 4, 1, 7, 8, 8, 3, 4, 6, 7,
                                                                                                               5, 2, 1, 3, 2, 7, 1, 8, 4, 6, 5, 7, 8, 5, 6, 2, 3, 4, 1, 3, 5,
                                                                                                               2, 6, 4, 7, 1, 8, 2, 3, 1, 5, 6, 4, 7, 8, 2, 7, 5, 6, 3, 8, 4,
                                                                                                               1, 4, 3, 7, 8, 2, 1, 5, 6, 4, 3, 5, 6, 5, 4, 6, 2, 5, 1, 4, 7,
                                                                                                               3, 8, 6, 5, 3, 4, 5, 4), Name = c("GASTALDELLO Beryl", "DAHLIA Kelsi",
                                                                                                                                                 "TETZLOFF Aly", "WATTEL Marie", "HINDS Natalie", "ATKINSON Alia",
                                                                                                                                                 "BRUCE Tain", "BLACK Haley", "DRESSEL Caeleb", "SHIELDS Tom",
                                                                                                                                                 "CIESLAK Marcin", "VEKOVISHCHEV Mikhail", "SZABO Szebasztian",
                                                                                                                                                 "RIVOLTA Matteo", "CARTER Dylan", "GUY James", "NELSON Beata",
                                                                                                                                                 "FLICKINGER Hali", "GASSON Helena", "DELOOF Ali", "PELLEGRINI Federica",
                                                                                                                                                 "DAWSON Kathleen", "BURIAN Katalin", "WILLMOTT Aimee", "MURPHY Ryan",
                                                                                                                                                 "KAWECKI Radoslaw", "GREENBANK Luke", "DIENER Christian", "HVAS Tomoe",
                                                                                                                                                 "de DEUS Leonardo", "SANTI Fabio", "SZARANEK Mark", "LAZOR Annie",
                                                                                                                                                 "KING Lilly", "PICKREM Sydney", "SEBASTIAN Julia", "CARRARO Martina",
                                                                                                                                                 "HANNIS Molly", "SMITH Kierra", "CASTIGLIONI Arianna", "LICON Will",
                                                                                                                                                 "PRIGODA Kirill", "PRENOT Josh", "MARTINENGHI Nicolo", "FINK Nic",
                                                                                                                                                 "CORDES Kevin", "GREENE Darragh", "SCOZZOLI Fabio", NA, NA, NA,
                                                                                                                                                 NA, NA, NA, NA, NA, "DRESSEL Caeleb", "GKOLOMEEV Kristian", "SZABO Szebasztian",
                                                                                                                                                 "RESS Justin", "ROONEY Maxime", "MIRESSI Alessandro", "LEVEAUX Amaury",
                                                                                                                                                 "VEKOVISHCHEV Mikhail", "WEITZEIL Abbey", "GASTALDELLO Beryl",
                                                                                                                                                 "SMOLIGA Olivia", "ANDERSON Freya", "BROWN Erika", "HOPKIN Anna",
                                                                                                                                                 "MUNOZ del CAMPO Lidon", "MEDEIROS Etiene", "LANZA Vini", "HEINTZ Philip",
                                                                                                                                                 "VAZAIOS Andreas", "SELISKAR Andrew", "PRENOT Josh", "SZARANEK Mark",
                                                                                                                                                 "PERIBONIO Tomas", "SANTI Fabio", "NELSON Beata", "PICKREM Sydney",
                                                                                                                                                 "GORBENKO Anastasia", "GASSON Helena", "WILLMOTT Aimee", "VERRASZTO Evelyn",
                                                                                                                                                 "FERTEL Kelly", "BLACK Haley", "MARTINENGHI Nicolo", "SILVA FRANCA Felipe",
                                                                                                                                                 "SCOZZOLI Fabio", "PRIGODA Kirill", "FINK Nic", "GREENE Darragh",
                                                                                                                                                 "LICON Will", "CORDES Kevin", "HANNIS Molly", "KING Lilly", "ATKINSON Alia",
                                                                                                                                                 "CARRARO Martina", "CASTIGLIONI Arianna", "LAZOR Annie", "SEBASTIAN Julia",
                                                                                                                                                 "GORBENKO Anastasia", NA, NA, NA, NA, NA, NA, NA, NA, "SMOLIGA Olivia",
                                                                                                                                                 "TOUSSAINT Kira", "MEDEIROS Etiene", "TETZLOFF Aly", "BROWN Erika",
                                                                                                                                                 "MARSH Alyssa", "DAWSON Kathleen", "KONOPKA REID Katrina", "MURPHY Ryan",
                                                                                                                                                 "GUIDO Guilherme", "DIENER Christian", "RESS Justin", "STEWART Coleman",
                                                                                                                                                 "de DEUS Leonardo", "HVAS Tomoe", "SANTI Fabio", "FLICKINGER Hali",
                                                                                                                                                 "DUMONT Valentine", "ANDERSON Haley", "HIBBOTT Holly", "WILLMOTT Aimee",
                                                                                                                                                 "MUREZ Andi", "SARGENT Makayla", "OLIVEIRA Larissa", "ROMANCHUK Mykhaylo",
                                                                                                                                                 "SCHEFFER Fernando", "DEAN Tom", "BAQLAH Khader", "GUY James",
                                                                                                                                                 "HEIDTMANN Jacob", "MELO Luiz Altamir", "PERIBONIO Tomas", NA,
                                                                                                                                                 NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "GASTALDELLO Beryl",
                                                                                                                                                 "WEITZEIL Abbey", "ANDERSON Freya", "HOPKIN Anna", "SCHMITT Allison",
                                                                                                                                                 "MUNOZ del CAMPO Lidon", "NEAL Lia", "OLIVEIRA Larissa", "DRESSEL Caeleb",
                                                                                                                                                 "MIRESSI Alessandro", "RESS Justin", "CHIERIGHINI Marcelo", "GKOLOMEEV Kristian",
                                                                                                                                                 "ROONEY Maxime", "SCOTT Duncan", "VEKOVISHCHEV Mikhail", "FLICKINGER Hali",
                                                                                                                                                 "GASSON Helena", "LARGE Emily", "HIBBOTT Holly", "VERRASZTO Evelyn",
                                                                                                                                                 "BRUCE Tain", "SARGENT Makayla", "FERTEL Kelly", "SHIELDS Tom",
                                                                                                                                                 "WANG Eddie", "LANZA Vini", "VAZAIOS Andreas", "de DEUS Leonardo",
                                                                                                                                                 "PRENOT Josh", "MELO Luiz Altamir", "SZARANEK Mark", "SMOLIGA Olivia",
                                                                                                                                                 "TOUSSAINT Kira", "BROWN Erika", "DELOOF Ali", "DAWSON Kathleen",
                                                                                                                                                 "TETZLOFF Aly", "MEDEIROS Etiene", "BURIAN Katalin", "MURPHY Ryan",
                                                                                                                                                 "CARTER Dylan", "KAWECKI Radoslaw", "GUIDO Guilherme", "STEWART Coleman",
                                                                                                                                                 "GREENBANK Luke", "RIVOLTA Matteo", "SANTI Fabio", "GASTALDELLO Beryl",
                                                                                                                                                 "GORBENKO Anastasia", "NELSON Beata", "KAMENEVA Maria", "FLICKINGER Hali",
                                                                                                                                                 "WILLMOTT Aimee", "KONOPKA REID Katrina", "BLACK Haley", "DRESSEL Caeleb",
                                                                                                                                                 "CIESLAK Marcin", "HVAS Tomoe", "VAZAIOS Andreas", "HEINTZ Philip",
                                                                                                                                                 "SELISKAR Andrew", "SCOTT Duncan", "de DEUS Leonardo", "ANDERSON Freya",
                                                                                                                                                 "MUREZ Andi", "SCHMITT Allison", "PELLEGRINI Federica", "DUMONT Valentine",
                                                                                                                                                 "RASMUS Claire", "BROWN Erika", "HIBBOTT Holly", "HAAS Townley",
                                                                                                                                                 "VEKOVISHCHEV Mikhail", "SCHEFFER Fernando", "DEAN Tom", "BAQLAH Khader",
                                                                                                                                                 "CORREIA Breno", "HEIDTMANN Jacob", "MELO Luiz Altamir", "GASTALDELLO Beryl",
                                                                                                                                                 "MARSH Alyssa", "DAHLIA Kelsi", "WATTEL Marie", "NELSON Beata",
                                                                                                                                                 "HOPKIN Anna", "BRUCE Tain", "BLACK Haley", "SZABO Szebasztian",
                                                                                                                                                 "DRESSEL Caeleb", "CIESLAK Marcin", "SHIELDS Tom", "RIVOLTA Matteo",
                                                                                                                                                 "ROONEY Maxime", "LANZA Vini", "GUY James", "KING Lilly", "ATKINSON Alia",
                                                                                                                                                 "CARRARO Martina", "LAZOR Annie", "CASTIGLIONI Arianna", "HANNIS Molly",
                                                                                                                                                 "SEBASTIAN Julia", "SMITH Kierra", "MARTINENGHI Nicolo", "SCOZZOLI Fabio",
                                                                                                                                                 "SILVA FRANCA Felipe", "LICON Will", "PRIGODA Kirill", "CORDES Kevin",
                                                                                                                                                 "FINK Nic", "GREENE Darragh", NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                 "PICKREM Sydney", "FLICKINGER Hali", "WILLMOTT Aimee", "SARGENT Makayla",
                                                                                                                                                 "GORBENKO Anastasia", "FERTEL Kelly", "VERRASZTO Evelyn", "DUMONT Valentine",
                                                                                                                                                 "SCOTT Duncan", "HEINTZ Philip", "HEIDTMANN Jacob", "PRENOT Josh",
                                                                                                                                                 "PERIBONIO Tomas", "ROMANCHUK Mykhaylo", "SZARANEK Mark", "DEAN Tom",
                                                                                                                                                 "KING Lilly", "HANNIS Molly", "CARRARO Martina", "CASTIGLIONI Arianna",
                                                                                                                                                 "ANDERSON Freya", "LAZOR Annie", "SEBASTIAN Julia", "GASSON Helena",
                                                                                                                                                 "KING Lilly", "HANNIS Molly", "CARRARO Martina", "CASTIGLIONI Arianna",
                                                                                                                                                 "KING Lilly", "HANNIS Molly", "MURPHY Ryan", "GUIDO Guilherme",
                                                                                                                                                 "CARTER Dylan", "DIENER Christian", "STEWART Coleman", "RIVOLTA Matteo",
                                                                                                                                                 "RESS Justin", "de DEUS Leonardo", "MURPHY Ryan", "CARTER Dylan",
                                                                                                                                                 "DIENER Christian", "GUIDO Guilherme", "MURPHY Ryan", "CARTER Dylan"
                                                                                                               ), Team = c("LAC", "CAC", "LAC", "LON", "CAC", "LON", "AQC",
                                                                                                                           "AQC", "CAC", "LAC", "CAC", "LON", "AQC", "AQC", "LAC", "LON",
                                                                                                                           "CAC", "CAC", "LAC", "LAC", "AQC", "LON", "AQC", "LON", "LAC",
                                                                                                                           "CAC", "LON", "LON", "LAC", "AQC", "AQC", "CAC", "LON", "CAC",
                                                                                                                           "LON", "LAC", "AQC", "CAC", "LAC", "AQC", "LAC", "LON", "LAC",
                                                                                                                           "AQC", "CAC", "CAC", "LON", "AQC", "LON", "CAC", "LAC", "AQC",
                                                                                                                           "LAC", "CAC", "AQC", "LON", "CAC", "LAC", "AQC", "CAC", "LAC",
                                                                                                                           "AQC", "LON", "LON", "LAC", "LAC", "CAC", "LON", "CAC", "LON",
                                                                                                                           "AQC", "AQC", "LON", "AQC", "LON", "LAC", "LAC", "CAC", "CAC",
                                                                                                                           "AQC", "CAC", "LON", "LAC", "LAC", "LON", "AQC", "CAC", "AQC",
                                                                                                                           "AQC", "LAC", "AQC", "LON", "CAC", "LON", "LAC", "CAC", "CAC",
                                                                                                                           "CAC", "LON", "AQC", "AQC", "LON", "LAC", "LAC", "CAC", "AQC",
                                                                                                                           "LAC", "LON", "LON", "CAC", "AQC", "LAC", "CAC", "LON", "AQC",
                                                                                                                           "LAC", "CAC", "LAC", "LON", "AQC", "LAC", "LON", "LON", "CAC",
                                                                                                                           "CAC", "AQC", "LAC", "AQC", "CAC", "AQC", "CAC", "LON", "LON",
                                                                                                                           "LAC", "LAC", "AQC", "AQC", "LAC", "LON", "CAC", "LON", "LAC",
                                                                                                                           "AQC", "CAC", "CAC", "LON", "LAC", "CAC", "LON", "LAC", "AQC",
                                                                                                                           "AQC", "LAC", "AQC", "LON", "CAC", "LON", "AQC", "CAC", "LAC",
                                                                                                                           "LAC", "LAC", "LON", "LON", "CAC", "AQC", "CAC", "AQC", "CAC",
                                                                                                                           "AQC", "CAC", "AQC", "LAC", "LAC", "LON", "LON", "CAC", "LAC",
                                                                                                                           "LON", "LON", "AQC", "AQC", "LAC", "CAC", "LAC", "CAC", "LON",
                                                                                                                           "LON", "AQC", "LAC", "AQC", "CAC", "CAC", "LON", "CAC", "LAC",
                                                                                                                           "LON", "LAC", "AQC", "AQC", "LAC", "LAC", "CAC", "LON", "CAC",
                                                                                                                           "LON", "AQC", "AQC", "LAC", "LAC", "CAC", "LON", "CAC", "LON",
                                                                                                                           "AQC", "AQC", "CAC", "CAC", "LAC", "LON", "AQC", "LAC", "LON",
                                                                                                                           "AQC", "LON", "LAC", "CAC", "AQC", "AQC", "LAC", "CAC", "LON",
                                                                                                                           "CAC", "LON", "LAC", "LON", "CAC", "AQC", "LAC", "AQC", "LAC",
                                                                                                                           "LAC", "CAC", "LON", "CAC", "LON", "AQC", "AQC", "AQC", "CAC",
                                                                                                                           "CAC", "LAC", "AQC", "LAC", "LON", "LON", "CAC", "LON", "AQC",
                                                                                                                           "LON", "AQC", "CAC", "LAC", "LAC", "AQC", "AQC", "LAC", "LAC",
                                                                                                                           "LON", "CAC", "CAC", "LON", "CAC", "LAC", "LON", "LAC", "CAC",
                                                                                                                           "AQC", "LON", "AQC", "LON", "CAC", "LON", "LAC", "LAC", "CAC",
                                                                                                                           "AQC", "AQC", "LON", "AQC", "LAC", "LAC", "CAC", "AQC", "CAC",
                                                                                                                           "LON", "CAC", "CAC", "AQC", "AQC", "LON", "LON", "LAC", "LAC",
                                                                                                                           "CAC", "CAC", "AQC", "AQC", "CAC", "CAC", "LAC", "LON", "LAC",
                                                                                                                           "LON", "CAC", "AQC", "CAC", "AQC", "LAC", "LAC", "LON", "LON",
                                                                                                                           "LAC", "LAC"), Time = c("55.71", "55.72", "56.46", "56.50", "57.10",
                                                                                                                                                   "57.21", "58.17", "1:00.14", "49.02", "49.17", "49.67", "49.88",
                                                                                                                                                   "49.89", "49.93", "50.70", "51.64", "2:02.51", "2:03.02", "2:05.29",
                                                                                                                                                   "2:05.62", "2:05.64", "2:05.92", "2:06.12", "2:08.34", "1:48.60",
                                                                                                                                                   "1:48.79", "1:50.50", "1:50.80", "1:53.54", "1:54.07", "1:57.73",
                                                                                                                                                   "1:58.84", "2:17.04", "2:17.18", "2:20.22", "2:20.89", "2:21.41",
                                                                                                                                                   "2:21.48", "2:22.20", "2:23.95", "2:04.12", "2:04.21", "2:06.60",
                                                                                                                                                   "2:07.04", "2:07.18", "2:07.22", "2:07.73", "2:07.81", "3:28.65",
                                                                                                                                                   "3:28.69", "3:29.69", "3:33.80", "3:34.26", "3:35.41", "3:38.42",
                                                                                                                                                   "3:41.19", "20.52", "20.89", "21.09", "21.17", "21.45", "21.48",
                                                                                                                                                   "21.80", "21.82", "23.45", "23.78", "24.05", "24.28", "24.34",
                                                                                                                                                   "24.41", "24.55", "24.59", "1:53.70", "1:53.73", "1:53.79", "1:54.17",
                                                                                                                                                   "1:54.97", "1:57.04", "1:57.05", "2:01.74", "2:05.95", "2:05.97",
                                                                                                                                                   "2:05.98", "2:08.02", "2:10.17", "2:11.31", "2:12.33", "2:23.47",
                                                                                                                                                   "25.89", "26.08", "26.39", "26.45", "26.88", "26.96", "27.11",
                                                                                                                                                   "27.12", "29.17", "29.18", "29.44", "29.60", "29.94", "30.42",
                                                                                                                                                   "30.73", NA, "3:05.52", "3:05.77", "3:06.99", "3:07.31", "3:11.19",
                                                                                                                                                   "3:11.65", "3:12.13", "3:12.52", "25.85", "26.32", "26.71", "26.75",
                                                                                                                                                   "26.81", "27.29", "27.48", "27.89", "22.75", "22.89", "23.24",
                                                                                                                                                   "23.27", "23.29", "23.76", "24.63", "24.81", "3:59.78", "4:00.05",
                                                                                                                                                   "4:03.74", "4:04.58", "4:07.16", "4:09.16", "4:09.45", "4:11.10",
                                                                                                                                                   "3:38.93", "3:41.07", "3:41.91", "3:42.09", "3:42.30", "3:43.96",
                                                                                                                                                   "3:50.60", "3:52.11", "3:47.13", "3:48.15", "3:49.87", "3:52.26",
                                                                                                                                                   "3:52.71", "3:54.04", "3:56.47", "3:58.14", "3:21.26", "3:22.78",
                                                                                                                                                   "3:24.73", "3:24.77", "3:25.68", "3:27.70", "3:28.04", "3:28.40",
                                                                                                                                                   "51.16", "51.26", "51.52", "51.97", "53.37", "53.42", "54.09",
                                                                                                                                                   "54.16", "45.56", "46.23", "46.25", "46.53", "46.73", "46.85",
                                                                                                                                                   "46.89", "46.99", "2:04.36", "2:07.27", "2:07.45", "2:08.60",
                                                                                                                                                   "2:09.75", "2:10.09", "2:10.80", "2:13.57", "1:49.78", "1:50.14",
                                                                                                                                                   "1:52.32", "1:52.92", "1:53.15", "1:54.93", "1:55.09", "1:58.74",
                                                                                                                                                   "55.92", "56.30", "57.24", "57.75", "58.02", "58.21", "58.44",
                                                                                                                                                   "59.23", "49.93", "50.11", "50.17", "50.19", "50.23", "50.54",
                                                                                                                                                   "50.78", "53.11", "57.43", "57.90", "58.60", "58.64", "1:00.22",
                                                                                                                                                   "1:01.63", "1:03.02", "1:07.23", "50.48", "51.36", "52.11", "52.73",
                                                                                                                                                   "52.91", "53.18", "53.19", "55.78", "1:52.82", "1:53.98", "1:54.45",
                                                                                                                                                   "1:55.10", "1:55.39", "1:57.17", "1:57.82", "1:57.88", "1:41.84",
                                                                                                                                                   "1:42.34", "1:42.71", "1:43.31", "1:43.40", "1:43.69", "1:45.58",
                                                                                                                                                   "1:46.47", "25.30", "25.31", "25.35", "25.60", "25.68", "25.95",
                                                                                                                                                   "27.09", "27.25", "21.86", "22.06", "22.55", "22.68", "22.77",
                                                                                                                                                   "22.87", "22.96", "23.55", "1:03.15", "1:04.43", "1:04.54", "1:04.55",
                                                                                                                                                   "1:04.61", "1:04.76", "1:05.51", "1:06.61", "56.46", "57.23",
                                                                                                                                                   "57.47", "57.88", "57.95", "58.29", "58.35", "59.10", "3:16.14",
                                                                                                                                                   "3:17.22", "3:18.18", "3:19.04", "3:19.94", "3:20.05", "3:20.53",
                                                                                                                                                   "3:21.92", "4:25.90", "4:29.52", "4:32.93", "4:34.03", "4:37.37",
                                                                                                                                                   "4:38.09", "4:39.30", "4:55.35", "4:07.88", "4:07.99", "4:08.03",
                                                                                                                                                   "4:08.60", "4:09.71", "4:10.00", "4:10.09", "4:10.35", "29.16",
                                                                                                                                                   "29.77", "29.81", "29.95", "30.13", "30.34", "30.60", "30.71",
                                                                                                                                                   "29.63", "29.99", "30.21", "30.33", "29.24", "29.85", "22.85",
                                                                                                                                                   "23.12", "23.28", "23.30", "23.37", "23.50", "23.51", "23.82",
                                                                                                                                                   "23.54", "23.93", "24.31", "24.40", "24.18", "24.99"), Event = c("Women's 100m Butterfly",
                                                                                                                                                                                                                    "Women's 100m Butterfly", "Women's 100m Butterfly", "Women's 100m Butterfly",
                                                                                                                                                                                                                    "Women's 100m Butterfly", "Women's 100m Butterfly", "Women's 100m Butterfly",
                                                                                                                                                                                                                    "Women's 100m Butterfly", "Men's 100m Butterfly", "Men's 100m Butterfly",
                                                                                                                                                                                                                    "Men's 100m Butterfly", "Men's 100m Butterfly", "Men's 100m Butterfly",
                                                                                                                                                                                                                    "Men's 100m Butterfly", "Men's 100m Butterfly", "Men's 100m Butterfly",
                                                                                                                                                                                                                    "Women's 200m Backstroke", "Women's 200m Backstroke", "Women's 200m Backstroke",
                                                                                                                                                                                                                    "Women's 200m Backstroke", "Women's 200m Backstroke", "Women's 200m Backstroke",
                                                                                                                                                                                                                    "Women's 200m Backstroke", "Women's 200m Backstroke", "Men's 200m Backstroke",
                                                                                                                                                                                                                    "Men's 200m Backstroke", "Men's 200m Backstroke", "Men's 200m Backstroke",
                                                                                                                                                                                                                    "Men's 200m Backstroke", "Men's 200m Backstroke", "Men's 200m Backstroke",
                                                                                                                                                                                                                    "Men's 200m Backstroke", "Women's 200m Breaststroke", "Women's 200m Breaststroke",
                                                                                                                                                                                                                    "Women's 200m Breaststroke", "Women's 200m Breaststroke", "Women's 200m Breaststroke",
                                                                                                                                                                                                                    "Women's 200m Breaststroke", "Women's 200m Breaststroke", "Women's 200m Breaststroke",
                                                                                                                                                                                                                    "Men's 200m Breaststroke", "Men's 200m Breaststroke", "Men's 200m Breaststroke",
                                                                                                                                                                                                                    "Men's 200m Breaststroke", "Men's 200m Breaststroke", "Men's 200m Breaststroke",
                                                                                                                                                                                                                    "Men's 200m Breaststroke", "Men's 200m Breaststroke", "Women's 4x100m Freestyle",
                                                                                                                                                                                                                    "Women's 4x100m Freestyle", "Women's 4x100m Freestyle", "Women's 4x100m Freestyle",
                                                                                                                                                                                                                    "Women's 4x100m Freestyle", "Women's 4x100m Freestyle", "Women's 4x100m Freestyle",
                                                                                                                                                                                                                    "Women's 4x100m Freestyle", "Men's 50m Freestyle", "Men's 50m Freestyle",
                                                                                                                                                                                                                    "Men's 50m Freestyle", "Men's 50m Freestyle", "Men's 50m Freestyle",
                                                                                                                                                                                                                    "Men's 50m Freestyle", "Men's 50m Freestyle", "Men's 50m Freestyle",
                                                                                                                                                                                                                    "Women's 50m Freestyle", "Women's 50m Freestyle", "Women's 50m Freestyle",
                                                                                                                                                                                                                    "Women's 50m Freestyle", "Women's 50m Freestyle", "Women's 50m Freestyle",
                                                                                                                                                                                                                    "Women's 50m Freestyle", "Women's 50m Freestyle", "Men's 200m Individual Medley",
                                                                                                                                                                                                                    "Men's 200m Individual Medley", "Men's 200m Individual Medley",
                                                                                                                                                                                                                    "Men's 200m Individual Medley", "Men's 200m Individual Medley",
                                                                                                                                                                                                                    "Men's 200m Individual Medley", "Men's 200m Individual Medley",
                                                                                                                                                                                                                    "Men's 200m Individual Medley", "Women's 200m Individual Medley",
                                                                                                                                                                                                                    "Women's 200m Individual Medley", "Women's 200m Individual Medley",
                                                                                                                                                                                                                    "Women's 200m Individual Medley", "Women's 200m Individual Medley",
                                                                                                                                                                                                                    "Women's 200m Individual Medley", "Women's 200m Individual Medley",
                                                                                                                                                                                                                    "Women's 200m Individual Medley", "Men's 50m Breaststroke", "Men's 50m Breaststroke",
                                                                                                                                                                                                                    "Men's 50m Breaststroke", "Men's 50m Breaststroke", "Men's 50m Breaststroke",
                                                                                                                                                                                                                    "Men's 50m Breaststroke", "Men's 50m Breaststroke", "Men's 50m Breaststroke",
                                                                                                                                                                                                                    "Women's 50m Breaststroke", "Women's 50m Breaststroke", "Women's 50m Breaststroke",
                                                                                                                                                                                                                    "Women's 50m Breaststroke", "Women's 50m Breaststroke", "Women's 50m Breaststroke",
                                                                                                                                                                                                                    "Women's 50m Breaststroke", "Women's 50m Breaststroke", "Men's 4x100m Freestyle",
                                                                                                                                                                                                                    "Men's 4x100m Freestyle", "Men's 4x100m Freestyle", "Men's 4x100m Freestyle",
                                                                                                                                                                                                                    "Men's 4x100m Freestyle", "Men's 4x100m Freestyle", "Men's 4x100m Freestyle",
                                                                                                                                                                                                                    "Men's 4x100m Freestyle", "Women's 50m Backstroke", "Women's 50m Backstroke",
                                                                                                                                                                                                                    "Women's 50m Backstroke", "Women's 50m Backstroke", "Women's 50m Backstroke",
                                                                                                                                                                                                                    "Women's 50m Backstroke", "Women's 50m Backstroke", "Women's 50m Backstroke",
                                                                                                                                                                                                                    "Men's 50m Backstroke", "Men's 50m Backstroke", "Men's 50m Backstroke",
                                                                                                                                                                                                                    "Men's 50m Backstroke", "Men's 50m Backstroke", "Men's 50m Backstroke",
                                                                                                                                                                                                                    "Men's 50m Backstroke", "Men's 50m Backstroke", "Women's 400m Freestyle",
                                                                                                                                                                                                                    "Women's 400m Freestyle", "Women's 400m Freestyle", "Women's 400m Freestyle",
                                                                                                                                                                                                                    "Women's 400m Freestyle", "Women's 400m Freestyle", "Women's 400m Freestyle",
                                                                                                                                                                                                                    "Women's 400m Freestyle", "Men's 400m Freestyle", "Men's 400m Freestyle",
                                                                                                                                                                                                                    "Men's 400m Freestyle", "Men's 400m Freestyle", "Men's 400m Freestyle",
                                                                                                                                                                                                                    "Men's 400m Freestyle", "Men's 400m Freestyle", "Men's 400m Freestyle",
                                                                                                                                                                                                                    "Women's 4x100m Medley Relay", "Women's 4x100m Medley Relay",
                                                                                                                                                                                                                    "Women's 4x100m Medley Relay", "Women's 4x100m Medley Relay",
                                                                                                                                                                                                                    "Women's 4x100m Medley Relay", "Women's 4x100m Medley Relay",
                                                                                                                                                                                                                    "Women's 4x100m Medley Relay", "Women's 4x100m Medley Relay",
                                                                                                                                                                                                                    "Men's 4x100m Medley Relay", "Men's 4x100m Medley Relay", "Men's 4x100m Medley Relay",
                                                                                                                                                                                                                    "Men's 4x100m Medley Relay", "Men's 4x100m Medley Relay", "Men's 4x100m Medley Relay",
                                                                                                                                                                                                                    "Men's 4x100m Medley Relay", "Men's 4x100m Medley Relay", "Women's 100m Freestyle",
                                                                                                                                                                                                                    "Women's 100m Freestyle", "Women's 100m Freestyle", "Women's 100m Freestyle",
                                                                                                                                                                                                                    "Women's 100m Freestyle", "Women's 100m Freestyle", "Women's 100m Freestyle",
                                                                                                                                                                                                                    "Women's 100m Freestyle", "Men's 100m Freestyle", "Men's 100m Freestyle",
                                                                                                                                                                                                                    "Men's 100m Freestyle", "Men's 100m Freestyle", "Men's 100m Freestyle",
                                                                                                                                                                                                                    "Men's 100m Freestyle", "Men's 100m Freestyle", "Men's 100m Freestyle",
                                                                                                                                                                                                                    "Women's 200m Butterfly", "Women's 200m Butterfly", "Women's 200m Butterfly",
                                                                                                                                                                                                                    "Women's 200m Butterfly", "Women's 200m Butterfly", "Women's 200m Butterfly",
                                                                                                                                                                                                                    "Women's 200m Butterfly", "Women's 200m Butterfly", "Men's 200m Butterfly",
                                                                                                                                                                                                                    "Men's 200m Butterfly", "Men's 200m Butterfly", "Men's 200m Butterfly",
                                                                                                                                                                                                                    "Men's 200m Butterfly", "Men's 200m Butterfly", "Men's 200m Butterfly",
                                                                                                                                                                                                                    "Men's 200m Butterfly", "Women's 100m Backstroke", "Women's 100m Backstroke",
                                                                                                                                                                                                                    "Women's 100m Backstroke", "Women's 100m Backstroke", "Women's 100m Backstroke",
                                                                                                                                                                                                                    "Women's 100m Backstroke", "Women's 100m Backstroke", "Women's 100m Backstroke",
                                                                                                                                                                                                                    "Men's 100m Backstroke", "Men's 100m Backstroke", "Men's 100m Backstroke",
                                                                                                                                                                                                                    "Men's 100m Backstroke", "Men's 100m Backstroke", "Men's 100m Backstroke",
                                                                                                                                                                                                                    "Men's 100m Backstroke", "Men's 100m Backstroke", "Women's 100m Individual Medley",
                                                                                                                                                                                                                    "Women's 100m Individual Medley", "Women's 100m Individual Medley",
                                                                                                                                                                                                                    "Women's 100m Individual Medley", "Women's 100m Individual Medley",
                                                                                                                                                                                                                    "Women's 100m Individual Medley", "Women's 100m Individual Medley",
                                                                                                                                                                                                                    "Women's 100m Individual Medley", "Men's 100m Individual Medley",
                                                                                                                                                                                                                    "Men's 100m Individual Medley", "Men's 100m Individual Medley",
                                                                                                                                                                                                                    "Men's 100m Individual Medley", "Men's 100m Individual Medley",
                                                                                                                                                                                                                    "Men's 100m Individual Medley", "Men's 100m Individual Medley",
                                                                                                                                                                                                                    "Men's 100m Individual Medley", "Women's 200m Freestyle", "Women's 200m Freestyle",
                                                                                                                                                                                                                    "Women's 200m Freestyle", "Women's 200m Freestyle", "Women's 200m Freestyle",
                                                                                                                                                                                                                    "Women's 200m Freestyle", "Women's 200m Freestyle", "Women's 200m Freestyle",
                                                                                                                                                                                                                    "Men's 200m Freestyle", "Men's 200m Freestyle", "Men's 200m Freestyle",
                                                                                                                                                                                                                    "Men's 200m Freestyle", "Men's 200m Freestyle", "Men's 200m Freestyle",
                                                                                                                                                                                                                    "Men's 200m Freestyle", "Men's 200m Freestyle", "Women's 50m Butterfly",
                                                                                                                                                                                                                    "Women's 50m Butterfly", "Women's 50m Butterfly", "Women's 50m Butterfly",
                                                                                                                                                                                                                    "Women's 50m Butterfly", "Women's 50m Butterfly", "Women's 50m Butterfly",
                                                                                                                                                                                                                    "Women's 50m Butterfly", "Men's 50m Butterfly", "Men's 50m Butterfly",
                                                                                                                                                                                                                    "Men's 50m Butterfly", "Men's 50m Butterfly", "Men's 50m Butterfly",
                                                                                                                                                                                                                    "Men's 50m Butterfly", "Men's 50m Butterfly", "Men's 50m Butterfly",
                                                                                                                                                                                                                    "Women's 100m Breaststroke", "Women's 100m Breaststroke", "Women's 100m Breaststroke",
                                                                                                                                                                                                                    "Women's 100m Breaststroke", "Women's 100m Breaststroke", "Women's 100m Breaststroke",
                                                                                                                                                                                                                    "Women's 100m Breaststroke", "Women's 100m Breaststroke", "Men's 100m Breaststroke",
                                                                                                                                                                                                                    "Men's 100m Breaststroke", "Men's 100m Breaststroke", "Men's 100m Breaststroke",
                                                                                                                                                                                                                    "Men's 100m Breaststroke", "Men's 100m Breaststroke", "Men's 100m Breaststroke",
                                                                                                                                                                                                                    "Men's 100m Breaststroke", "Mixed 4x100m Freestyle", "Mixed 4x100m Freestyle",
                                                                                                                                                                                                                    "Mixed 4x100m Freestyle", "Mixed 4x100m Freestyle", "Mixed 4x100m Freestyle",
                                                                                                                                                                                                                    "Mixed 4x100m Freestyle", "Mixed 4x100m Freestyle", "Mixed 4x100m Freestyle",
                                                                                                                                                                                                                    "Women's 400m Individual Medley", "Women's 400m Individual Medley",
                                                                                                                                                                                                                    "Women's 400m Individual Medley", "Women's 400m Individual Medley",
                                                                                                                                                                                                                    "Women's 400m Individual Medley", "Women's 400m Individual Medley",
                                                                                                                                                                                                                    "Women's 400m Individual Medley", "Women's 400m Individual Medley",
                                                                                                                                                                                                                    "Men's 400m Individual Medley", "Men's 400m Individual Medley",
                                                                                                                                                                                                                    "Men's 400m Individual Medley", "Men's 400m Individual Medley",
                                                                                                                                                                                                                    "Men's 400m Individual Medley", "Men's 400m Individual Medley",
                                                                                                                                                                                                                    "Men's 400m Individual Medley", "Men's 400m Individual Medley",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Women's 50m Breaststroke Skins", "Women's 50m Breaststroke Skins",
                                                                                                                                                                                                                    "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins",
                                                                                                                                                                                                                    "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins",
                                                                                                                                                                                                                    "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins",
                                                                                                                                                                                                                    "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins",
                                                                                                                                                                                                                    "Men's 50m Backstroke Skins", "Men's 50m Backstroke Skins"),
                                  Points = c(12, 7, 6, 5, 4, 3, 0, -1, 10, 7, 6, 5, 4, 3, 2,
                                             0, 10, 7, 6, 5, 4, 3, 2, 0, 19, 7, 6, 5, 0, 0, 0, -1, 10,
                                             7, 6, 5, 4, 3, 2, 0, 9, 7, 6, 5, 4, 3, 2, 1, 20, 14, 12,
                                             10, 8, 6, 4, -2, 19, 7, 6, 5, 0, 0, 0, 0, 15, 7, 6, 5, 4,
                                             0, 0, 0, 10, 7, 6, 5, 4, 3, 2, -1, 15, 7, 6, 5, 4, 0, 0,
                                             -1, 15, 7, 6, 5, 4, 0, 0, 0, 15, 7, 6, 5, 4, 0, 0, -2, 18,
                                             14, 12, 10, 8, 6, 4, 2, 15, 7, 6, 5, 4, 0, 0, 0, 15, 7, 6,
                                             5, 4, 0, 0, 0, 12, 7, 6, 5, 4, 3, 0, -1, 12, 7, 6, 5, 4,
                                             3, -1, -1, 20, 14, 12, 10, 8, 6, 4, 0, 18, 14, 12, 10, 8,
                                             6, 4, 2, 19, 7, 6, 5, 0, 0, 0, 0, 9, 7, 6, 5, 4, 3, 2, 1,
                                             19, 7, 6, 5, 0, 0, 0, -1, 15, 7, 6, 5, 4, 0, 0, 0, 15, 7,
                                             6, 5, 4, 0, 0, 0, 10, 7, 6, 5, 4, 3, 2, 0, 19, 7, 6, 5, 0,
                                             0, -1, -1, 24, 7, 6, 0, 0, 0, 0, -1, 12, 7, 6, 5, 4, 3, 0,
                                             0, 10, 7, 6, 5, 4, 3, 2, 0, 12, 7, 6, 5, 4, 3, -1, -1, 19,
                                             7, 6, 5, 0, 0, 0, 0, 10, 7, 6, 5, 4, 3, 2, 0, 10, 7, 6, 5,
                                             4, 3, 2, 0, 18, 14, 12, 10, 8, 6, 4, 2, 19, 7, 6, 5, 0, 0,
                                             0, -1, 9, 7, 6, 5, 4, 3, 2, 1, 15, 7, 6, 5, 4, 0, 0, 0, 9,
                                             7, 6, 5, 14, 7, 10, 7, 6, 5, 4, 3, 2, 0, 9, 7, 6, 5, 14,
                                             7), DQ = c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                                        0, 0, 0, 0), Relay_Swimmer_1 = c(NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "HOPKIN Anna",
                                                                                         "SMOLIGA Olivia", "MUREZ Andi", "MUNOZ del CAMPO Lidon",
                                                                                         "STEWART Kendyl", "NEAL Lia", "KONOPKA REID Katrina", "HIBBOTT Holly",
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, "MAJCHRZAK Kacper", "MIRESSI Alessandro", "FERREIRA Marco",
                                                                                         "SCOTT Duncan", "CLOGG Elliot", "CIESLAK Marcin", "CORREIA Breno",
                                                                                         "CARTER Dylan", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, "SMOLIGA Olivia", "TOUSSAINT Kira",
                                                                                         "DELOOF Ali", "NELSON Beata", "KAMENEVA Maria", "GASSON Helena",
                                                                                         "PELLEGRINI Federica", "BURIAN Katalin", "MURPHY Ryan", "RIVOLTA Matteo",
                                                                                         "DIENER Christian", "STEWART Coleman", "GREENBANK Luke",
                                                                                         "de DEUS Leonardo", "KAWECKI Radoslaw", "CHRISTOU Apostolos",
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, "RESS Justin", "GKOLOMEEV Kristian",
                                                                                         "VEKOVISHCHEV Mikhail", "CHRISTOU Apostolos", "JACKSON Tate",
                                                                                         "MIRESSI Alessandro", "VAZAIOS Andreas", "SZABO Szebasztian",
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                         NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA),
                                  Relay_Swimmer_2 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, "ANDERSON Freya", "BROWN Erika",
                                                      "GORBENKO Anastasia", "PELLEGRINI Federica", "RASMUS Claire",
                                                      "BURCHILL Veronica", "MEDEIROS Etiene", "WEST Harriet", NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, "JACKSON Tate", "SPAJARI Pedro", "SHIELDS Tom", "KUSCH Marius",
                                                      "DEAN Tom", "WANG Eddie", "SANTOS Gabriel", "CHRISTOU Apostolos",
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, "KING Lilly", "ATKINSON Alia", "GORBENKO Anastasia",
                                                      "HANNIS Molly", "LAZOR Annie", "SEBASTIAN Julia", "CARRARO Martina",
                                                      "CASTIGLIONI Arianna", "SILVA FRANCA Felipe", "MARTINENGHI Nicolo",
                                                      "PRIGODA Kirill", "FINK Nic", "GREENE Darragh", "SCOZZOLI Fabio",
                                                      "CORDES Kevin", "LICON Will", NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      "DRESSEL Caeleb", "SHIELDS Tom", "KUSCH Marius", "FERREIRA Marco",
                                                      "MAJCHRZAK Kacper", "CHIERIGHINI Marcelo", "CLOGG Elliot",
                                                      "SPAJARI Pedro", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                      NA, NA, NA, NA), Relay_Swimmer_3 = c(NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "WATTEL Marie",
                                                                                           "SCHMITT Allison", "MARSH Alyssa", "OLIVEIRA Larissa", "McLAUGHLIN Katie",
                                                                                           "FLICKINGER Hali", "BRUCE Tain", "LARGE Emily", NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           "HAAS Townley", "SZABO Szebasztian", "GKOLOMEEV Kristian",
                                                                                           "LANZA Vini", "LEVEAUX Amaury", "KAWECKI Radoslaw", "MELO Luiz Altamir",
                                                                                           "HVAS Tomoe", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, "DAHLIA Kelsi", "WATTEL Marie", "GASTALDELLO Beryl",
                                                                                           "HINDS Natalie", "WEST Harriet", "STEWART Kendyl", "BRUCE Tain",
                                                                                           "TOURETSKI Sasha Alexandra", "SHIELDS Tom", "SZABO Szebasztian",
                                                                                           "KUSCH Marius", "DRESSEL Caeleb", "VEKOVISHCHEV Mikhail",
                                                                                           "HEINTZ Philip", "JACKSON Tate", "CARTER Dylan", NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, "SMOLIGA Olivia", "GASTALDELLO Beryl",
                                                                                           "KAMENEVA Maria", "TETZLOFF Aly", "SCHMITT Allison", "MUNOZ del CAMPO Lidon",
                                                                                           "WATTEL Marie", "PELLEGRINI Federica", NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                           NA, NA, NA, NA, NA, NA, NA, NA, NA), Relay_Swimmer_4 = c(NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, "KAMENEVA Maria", "HINDS Natalie", "TETZLOFF Aly",
                                                                                                                                                    "DUMONT Valentine", "WEITZEIL Abbey", "DAHLIA Kelsi", "TOURETSKI Sasha Alexandra",
                                                                                                                                                    "DAWSON Kathleen", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, "DRESSEL Caeleb", "CHIERIGHINI Marcelo",
                                                                                                                                                    "ROONEY Maxime", "VEKOVISHCHEV Mikhail", "VAZAIOS Andreas",
                                                                                                                                                    "SZARANEK Mark", "HEINTZ Philip", "SELISKAR Andrew", NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, "BROWN Erika", "ANDERSON Freya", "WEITZEIL Abbey", "SCHMITT Allison",
                                                                                                                                                    "HOPKIN Anna", "TETZLOFF Aly", "MUNOZ del CAMPO Lidon", "KONOPKA REID Katrina",
                                                                                                                                                    "ROONEY Maxime", "MIRESSI Alessandro", "SCOTT Duncan", "MAJCHRZAK Kacper",
                                                                                                                                                    "LANZA Vini", "CHIERIGHINI Marcelo", "RESS Justin", "FERREIRA Marco",
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, "BROWN Erika", "WEITZEIL Abbey",
                                                                                                                                                    "ANDERSON Freya", "MUREZ Andi", "HINDS Natalie", "OLIVEIRA Larissa",
                                                                                                                                                    "HOPKIN Anna", "DUMONT Valentine", NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                    NA, NA, NA, NA, NA, NA, NA, NA), Split_50 = c("25.85", "26.04",
                                                                                                                                                                                                  "26.07", "26.09", "26.70", "26.88", "27.23", "27.46", "23.32",
                                                                                                                                                                                                  "22.85", "23.39", "23.19", "23.09", "23.23", "23.30", "23.83",
                                                                                                                                                                                                  "28.70", "29.45", "29.65", "29.20", "29.55", "29.08", "29.60",
                                                                                                                                                                                                  "30.07", "25.50", "26.36", "26.04", "25.72", "26.72", "26.40",
                                                                                                                                                                                                  "26.81", "27.38", "31.76", "30.61", "32.37", "32.09", "32.51",
                                                                                                                                                                                                  "32.06", "32.35", "33.06", "28.65", "28.08", "29.21", "28.32",
                                                                                                                                                                                                  "28.90", "28.62", "28.93", "28.41", "25.12", "24.98", "24.87",
                                                                                                                                                                                                  "25.71", "25.48", "26.02", "26.13", "26.69", NA, NA, NA,
                                                                                                                                                                                                  NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "24.54",
                                                                                                                                                                                                  "24.29", "25.39", "24.51", "25.02", "25.58", "25.39", "26.22",
                                                                                                                                                                                                  "27.24", "28.09", "28.04", "27.53", "28.66", "28.58", "28.39",
                                                                                                                                                                                                  "27.41", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                  NA, NA, NA, NA, "22.59", "22.33", "22.65", "22.68", "22.90",
                                                                                                                                                                                                  "22.81", "22.95", "22.24", NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                  NA, NA, NA, NA, NA, NA, NA, NA, "28.25", "28.68", "28.49",
                                                                                                                                                                                                  "28.58", "29.01", "28.69", "28.75", "28.85", "25.93", "25.08",
                                                                                                                                                                                                  "25.65", "25.89", "25.65", "25.71", "25.37", "26.27", "27.31",
                                                                                                                                                                                                  "27.57", "27.29", "27.88", "28.06", "27.85", "28.78", "29.09",
                                                                                                                                                                                                  "23.96", "24.95", "24.61", "24.46", "24.65", "24.92", "24.93",
                                                                                                                                                                                                  "24.67", "24.77", "24.43", "25.54", "24.87", "25.57", "25.51",
                                                                                                                                                                                                  "25.97", "25.87", "22.14", "22.26", "22.17", "21.88", "22.32",
                                                                                                                                                                                                  "22.13", "22.66", "22.52", "28.52", "28.84", "28.88", "29.20",
                                                                                                                                                                                                  "28.98", "29.03", "29.34", "29.35", "24.57", "25.02", "25.07",
                                                                                                                                                                                                  "25.80", "25.13", "25.63", "25.11", "26.02", "27.21", "27.03",
                                                                                                                                                                                                  "27.51", "27.77", "27.92", "28.04", "28.11", "28.90", "24.03",
                                                                                                                                                                                                  "23.81", "24.42", "24.19", "24.29", "24.63", "24.74", "25.44",
                                                                                                                                                                                                  "26.33", "26.27", "26.77", "26.69", "28.01", "28.37", "27.89",
                                                                                                                                                                                                  "28.87", "22.96", "23.50", "23.53", "24.10", "24.04", "24.16",
                                                                                                                                                                                                  "24.44", "24.85", "26.80", "26.84", "27.52", "27.42", "27.35",
                                                                                                                                                                                                  "27.92", "27.37", "27.95", "23.83", "24.12", "24.58", "24.14",
                                                                                                                                                                                                  "24.32", "24.49", "24.55", "24.02", NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                  NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "29.59", "30.18",
                                                                                                                                                                                                  "31.00", "30.73", "30.57", "30.56", "31.09", "31.71", "26.42",
                                                                                                                                                                                                  "26.58", "27.08", "27.41", "27.23", "27.28", "27.39", "27.49",
                                                                                                                                                                                                  "22.18", "22.31", "22.80", "22.78", "22.59", "22.15", "22.96",
                                                                                                                                                                                                  "22.61", "29.50", "29.05", "29.47", "29.47", "28.84", "29.42",
                                                                                                                                                                                                  "29.43", "30.29", "25.66", "26.10", "26.81", "26.33", "26.45",
                                                                                                                                                                                                  "27.09", "26.61", "26.52", NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                  NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                  NA, NA, NA, NA, NA), Split_100 = c("29.86", "29.68", "30.39",
                                                                                                                                                                                                                                     "30.41", "30.40", "30.33", "30.94", "32.68", "25.70", "26.32",
                                                                                                                                                                                                                                     "26.28", "26.69", "26.80", "26.70", "27.40", "27.81", "30.84",
                                                                                                                                                                                                                                     "31.06", "32.11", "31.74", "31.64", "31.91", "31.97", "31.99",
                                                                                                                                                                                                                                     "27.88", "28.29", "28.34", "28.20", "27.94", "28.75", "29.66",
                                                                                                                                                                                                                                     "29.62", "35.25", "35.73", "35.78", "35.78", "36.64", "36.97",
                                                                                                                                                                                                                                     "35.76", "37.01", "31.32", "31.59", "32.12", "32.48", "32.44",
                                                                                                                                                                                                                                     "31.97", "32.29", "32.98", "52.29", "51.95", "52.16", "53.64",
                                                                                                                                                                                                                                     "53.31", "54.46", "54.92", "55.44", NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                     NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "29.38", "28.59",
                                                                                                                                                                                                                                     "28.09", "28.18", "29.63", "29.01", "29.33", "29.69", "32.29",
                                                                                                                                                                                                                                     "31.83", "32.67", "32.29", "33.54", "32.96", "33.37", "36.64",
                                                                                                                                                                                                                                     NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                     NA, "46.98", "46.58", "47.59", "47.14", "47.95", "47.12",
                                                                                                                                                                                                                                     "47.46", "46.56", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                     NA, NA, NA, NA, NA, NA, "30.22", "30.68", "30.62", "30.74",
                                                                                                                                                                                                                                     "30.98", "30.99", "31.09", "30.70", "27.46", "27.56", "28.37",
                                                                                                                                                                                                                                     "27.80", "28.06", "27.67", "27.77", "28.08", "56.24", "57.07",
                                                                                                                                                                                                                                     "57.76", "57.47", "58.20", "57.96", "59.09", "59.76", "49.80",
                                                                                                                                                                                                                                     "51.39", "50.77", "50.85", "50.99", "51.38", "50.67", "51.55",
                                                                                                                                                                                                                                     "26.39", "26.83", "25.98", "27.10", "27.80", "27.91", "28.12",
                                                                                                                                                                                                                                     "28.29", "23.42", "23.97", "24.08", "24.65", "24.41", "24.72",
                                                                                                                                                                                                                                     "24.23", "24.47", "31.42", "32.50", "32.33", "33.10", "33.13",
                                                                                                                                                                                                                                     "32.70", "32.85", "33.93", "28.20", "28.19", "28.81", "28.99",
                                                                                                                                                                                                                                     "29.04", "29.33", "28.54", "29.54", "28.71", "29.27", "29.73",
                                                                                                                                                                                                                                     "29.98", "30.10", "30.17", "30.33", "30.33", "25.90", "26.30",
                                                                                                                                                                                                                                     "25.75", "26.00", "25.94", "25.91", "26.04", "27.67", "31.10",
                                                                                                                                                                                                                                     "31.63", "31.83", "31.95", "32.21", "33.26", "35.13", "38.36",
                                                                                                                                                                                                                                     "27.52", "27.86", "28.58", "28.63", "28.87", "29.02", "28.75",
                                                                                                                                                                                                                                     "30.93", "28.98", "28.98", "28.90", "29.34", "28.98", "29.81",
                                                                                                                                                                                                                                     "29.48", "29.91", "25.83", "25.91", "26.14", "26.49", "26.21",
                                                                                                                                                                                                                                     "26.59", "26.63", "25.90", NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                     NA, NA, NA, NA, NA, NA, NA, NA, "33.56", "34.25", "33.54",
                                                                                                                                                                                                                                     "33.82", "34.04", "34.20", "34.42", "34.90", "30.04", "30.65",
                                                                                                                                                                                                                                     "30.39", "30.47", "30.72", "31.01", "30.96", "31.61", "46.22",
                                                                                                                                                                                                                                     "46.87", "47.53", "47.27", "47.43", "46.74", "47.76", "47.21",
                                                                                                                                                                                                                                     "33.02", "32.67", "33.32", "33.19", "34.37", "34.06", "33.73",
                                                                                                                                                                                                                                     "34.30", "29.18", "30.02", "30.55", "30.35", "30.08", "30.14",
                                                                                                                                                                                                                                     "30.78", "30.47", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                     NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                     NA, NA, NA), Split_150 = c(NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, "31.30", "31.40", "31.78",
                                                                                                                                                                                                                                                                "32.30", "32.07", "32.48", "32.06", "33.00", "27.99", "27.10",
                                                                                                                                                                                                                                                                "28.32", "28.57", "28.96", "29.34", "30.47", "31.00", "35.18",
                                                                                                                                                                                                                                                                "36.44", "36.06", "36.59", "36.43", "36.50", "36.69", "37.43",
                                                                                                                                                                                                                                                                "32.00", "32.25", "32.48", "33.09", "32.94", "32.80", "32.99",
                                                                                                                                                                                                                                                                "33.68", "24.89", "24.74", "24.75", "25.79", "25.98", "25.53",
                                                                                                                                                                                                                                                                "25.57", "26.13", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, "32.81", "32.81", "32.70", "33.21",
                                                                                                                                                                                                                                                                "32.34", "34.48", "33.90", "36.91", "36.63", "35.77", "35.96",
                                                                                                                                                                                                                                                                "37.56", "36.62", "39.56", "38.72", "44.16", NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "22.28",
                                                                                                                                                                                                                                                                "21.81", "21.84", "22.11", "22.51", "22.92", "22.69", "22.00",
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, "30.46", "30.81", "30.55", "31.04", "31.22", "31.32",
                                                                                                                                                                                                                                                                "31.40", "31.04", "27.69", "27.78", "28.49", "28.26", "28.24",
                                                                                                                                                                                                                                                                "28.13", "28.40", "28.50", "29.49", "29.65", "30.42", "29.94",
                                                                                                                                                                                                                                                                "30.54", "31.15", "30.69", "30.00", "26.43", "26.09", "26.16",
                                                                                                                                                                                                                                                                "27.10", "27.11", "27.24", "27.31", "27.23", NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "32.14",
                                                                                                                                                                                                                                                                "32.59", "32.76", "33.38", "33.55", "33.77", "33.49", "34.57",
                                                                                                                                                                                                                                                                "28.16", "28.42", "28.88", "28.75", "29.38", "29.73", "29.87",
                                                                                                                                                                                                                                                                "30.88", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, "28.92", "29.20", "29.21", "29.35", "29.62",
                                                                                                                                                                                                                                                                "29.73", "30.51", "30.18", "25.97", "26.08", "26.18", "26.26",
                                                                                                                                                                                                                                                                "26.31", "26.60", "26.92", "27.09", NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "21.96", "22.17",
                                                                                                                                                                                                                                                                "22.17", "22.09", "22.56", "21.76", "22.24", "21.94", "34.30",
                                                                                                                                                                                                                                                                "34.58", "34.60", "34.77", "36.97", "36.18", "35.56", "38.57",
                                                                                                                                                                                                                                                                "31.45", "33.20", "32.54", "33.26", "32.26", "32.14", "32.16",
                                                                                                                                                                                                                                                                "32.58", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                NA), Split_200 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, "31.67", "31.11", "31.75", "32.38",
                                                                                                                                                                                                                                                                                   "32.38", "32.45", "32.49", "33.28", "27.23", "27.04", "27.80",
                                                                                                                                                                                                                                                                                   "28.31", "29.92", "29.58", "30.79", "30.84", "34.85", "34.40",
                                                                                                                                                                                                                                                                                   "36.01", "36.43", "35.83", "35.95", "37.40", "36.45", "32.15",
                                                                                                                                                                                                                                                                                   "32.29", "32.79", "33.15", "32.90", "33.83", "33.52", "32.74",
                                                                                                                                                                                                                                                                                   "51.76", "52.00", "51.69", "53.82", "54.39", "54.49", "53.85",
                                                                                                                                                                                                                                                                                   "54.74", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, "26.97", "28.04", "27.61", "28.27", "27.98",
                                                                                                                                                                                                                                                                                   "27.97", "28.43", "28.92", "29.79", "30.28", "29.31", "30.64",
                                                                                                                                                                                                                                                                                   "31.35", "30.21", "31.85", "35.26", NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "47.04", "46.25",
                                                                                                                                                                                                                                                                                   "46.23", "47.23", "47.35", "47.85", "47.37", "47.13", NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   "30.60", "30.60", "30.79", "31.21", "31.39", "31.97", "31.40",
                                                                                                                                                                                                                                                                                   "31.35", "27.81", "28.23", "28.50", "28.29", "28.53", "28.70",
                                                                                                                                                                                                                                                                                   "28.86", "29.23", "1:03.03", "1:03.75", "1:04.62", "1:04.15",
                                                                                                                                                                                                                                                                                   "1:04.66", "1:05.95", "1:05.28", "1:03.48", "56.54", "56.13",
                                                                                                                                                                                                                                                                                   "56.77", "58.18", "57.88", "58.26", "58.49", "58.32", NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   "32.28", "33.34", "33.48", "32.92", "34.09", "34.59", "35.12",
                                                                                                                                                                                                                                                                                   "35.72", "28.85", "28.51", "29.56", "29.38", "29.60", "30.24",
                                                                                                                                                                                                                                                                                   "31.57", "32.30", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, "28.12", "28.96", "28.82", "28.99",
                                                                                                                                                                                                                                                                                   "29.44", "29.71", "30.46", "29.84", "26.21", "26.23", "25.81",
                                                                                                                                                                                                                                                                                   "26.42", "26.56", "26.01", "27.48", "29.46", NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "45.72",
                                                                                                                                                                                                                                                                                   "46.53", "46.71", "46.77", "46.88", "45.95", "47.58", "46.57",
                                                                                                                                                                                                                                                                                   "33.35", "33.26", "34.37", "34.37", "36.00", "35.35", "34.32",
                                                                                                                                                                                                                                                                                   "36.85", "31.67", "32.21", "32.09", "32.26", "32.44", "31.30",
                                                                                                                                                                                                                                                                                   "32.17", "31.70", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                   NA, NA, NA), Split_250 = c(NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "25.32", "25.08",
                                                                                                                                                                                                                                                                                                              "24.90", "25.48", "26.05", "25.58", "26.02", "26.33", NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, "21.80", "22.03", "22.14", "22.63", "22.67", "22.18",
                                                                                                                                                                                                                                                                                                              "23.02", "23.14", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, "30.59", "30.55", "30.83", "30.94",
                                                                                                                                                                                                                                                                                                              "31.20", "31.56", "31.28", "31.25", "27.69", "28.00", "28.19",
                                                                                                                                                                                                                                                                                                              "27.94", "28.47", "28.25", "28.95", "29.94", "26.02", "25.77",
                                                                                                                                                                                                                                                                                                              "25.71", "26.62", "26.47", "25.60", "27.13", "27.58", "22.22",
                                                                                                                                                                                                                                                                                                              "22.57", "23.27", "23.13", "22.74", "23.81", "24.27", "23.39",
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, "24.72", "25.05", "24.98", "24.80",
                                                                                                                                                                                                                                                                                                              "25.92", "25.38", "25.41", "25.65", "36.60", "39.84", "37.42",
                                                                                                                                                                                                                                                                                                              "38.47", "38.50", "39.37", "41.40", "45.07", "35.05", "35.21",
                                                                                                                                                                                                                                                                                                              "34.21", "33.82", "34.79", "35.94", "33.99", "36.43", NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                              NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), Split_300 = c(NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, "52.52", "52.49", "53.07", "53.09", "53.71", "53.09",
                                                                                                                                                                                                                                                                                                                                                                             "54.54", "54.94", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, "46.22", "46.87", "46.71",
                                                                                                                                                                                                                                                                                                                                                                             "46.85", "47.85", "47.59", "48.09", "49.53", NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "30.48",
                                                                                                                                                                                                                                                                                                                                                                             "30.31", "30.93", "30.89", "31.27", "31.44", "31.81", "32.19",
                                                                                                                                                                                                                                                                                                                                                                             "27.78", "28.40", "27.83", "28.06", "28.43", "28.26", "29.83",
                                                                                                                                                                                                                                                                                                                                                                             "29.79", "56.37", "56.59", "56.20", "57.92", "57.36", "56.93",
                                                                                                                                                                                                                                                                                                                                                                             "58.53", "59.87", "48.92", "49.32", "50.30", "49.55", "49.30",
                                                                                                                                                                                                                                                                                                                                                                             "51.24", "52.88", "51.25", NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "52.09",
                                                                                                                                                                                                                                                                                                                                                                             "52.63", "52.64", "53.01", "53.61", "53.46", "53.58", "53.37",
                                                                                                                                                                                                                                                                                                                                                                             "37.27", "39.41", "39.15", "39.20", "38.52", "40.15", "41.97",
                                                                                                                                                                                                                                                                                                                                                                             "44.14", "36.22", "35.11", "35.18", "34.67", "35.89", "36.40",
                                                                                                                                                                                                                                                                                                                                                                             "35.55", "36.74", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                             NA, NA, NA), Split_350 = c(NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "24.75", "25.11",
                                                                                                                                                                                                                                                                                                                                                                                                        "24.81", "25.63", "25.06", "25.21", "25.74", "26.70", NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, "21.79", "21.52", "21.90", "21.72", "23.19", "23.31",
                                                                                                                                                                                                                                                                                                                                                                                                        "23.42", "23.51", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, "30.30", "29.59", "30.89", "30.81",
                                                                                                                                                                                                                                                                                                                                                                                                        "31.03", "31.80", "32.10", "32.89", "27.80", "28.34", "27.81",
                                                                                                                                                                                                                                                                                                                                                                                                        "28.26", "28.00", "28.46", "30.77", "30.28", "24.25", "24.51",
                                                                                                                                                                                                                                                                                                                                                                                                        "24.00", "25.17", "25.14", "25.16", "25.47", "25.75", "21.50",
                                                                                                                                                                                                                                                                                                                                                                                                        "21.94", "22.29", "22.21", "22.90", "22.07", "21.92", "22.56",
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, "24.63", "24.01", "24.93", "24.69",
                                                                                                                                                                                                                                                                                                                                                                                                        "24.93", "25.54", "24.72", "26.60", "31.68", "30.97", "32.89",
                                                                                                                                                                                                                                                                                                                                                                                                        "32.37", "32.75", "32.50", "32.16", "34.08", "29.67", "29.34",
                                                                                                                                                                                                                                                                                                                                                                                                        "29.33", "30.76", "29.43", "29.19", "29.98", "28.83", NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                        NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA), Split_400 = c(NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, "52.08", "52.25", "52.77", "53.25", "52.85", "53.37",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "55.11", "56.07", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, "45.28", "46.07", "46.46",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "46.09", "48.04", "49.09", "49.21", "49.30", NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "28.88",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "28.83", "30.64", "30.37", "31.06", "31.39", "31.62", "32.83",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "26.77", "27.68", "27.07", "27.59", "26.92", "28.78", "30.65",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "30.02", "51.49", "50.74", "51.29", "52.72", "52.49", "53.20",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "53.57", "55.03", "46.00", "45.94", "46.89", "46.19", "47.51",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "46.82", "46.00", "47.28", NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, "52.11",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "51.19", "51.30", "51.99", "52.02", "53.90", "51.61", "54.77",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "30.18", "29.74", "31.71", "32.19", "31.42", "31.06", "30.73",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "32.05", "28.98", "26.80", "27.32", "27.15", "28.37", "27.80",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       "28.85", "27.08", NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       NA, NA, NA)), row.names = c(NA, -324L), class = c("rowwise_df",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         "tbl_df", "tbl", "data.frame"), groups = structure(list(.rows = structure(list(
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           27L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L, 36L, 37L, 38L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           39L, 40L, 41L, 42L, 43L, 44L, 45L, 46L, 47L, 48L, 49L, 50L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 59L, 60L, 61L, 62L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           63L, 64L, 65L, 66L, 67L, 68L, 69L, 70L, 71L, 72L, 73L, 74L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           75L, 76L, 77L, 78L, 79L, 80L, 81L, 82L, 83L, 84L, 85L, 86L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           87L, 88L, 89L, 90L, 91L, 92L, 93L, 94L, 95L, 96L, 97L, 98L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           99L, 100L, 101L, 102L, 103L, 104L, 105L, 106L, 107L, 108L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           109L, 110L, 111L, 112L, 113L, 114L, 115L, 116L, 117L, 118L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           119L, 120L, 121L, 122L, 123L, 124L, 125L, 126L, 127L, 128L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           129L, 130L, 131L, 132L, 133L, 134L, 135L, 136L, 137L, 138L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           139L, 140L, 141L, 142L, 143L, 144L, 145L, 146L, 147L, 148L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           149L, 150L, 151L, 152L, 153L, 154L, 155L, 156L, 157L, 158L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           159L, 160L, 161L, 162L, 163L, 164L, 165L, 166L, 167L, 168L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           169L, 170L, 171L, 172L, 173L, 174L, 175L, 176L, 177L, 178L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           179L, 180L, 181L, 182L, 183L, 184L, 185L, 186L, 187L, 188L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           189L, 190L, 191L, 192L, 193L, 194L, 195L, 196L, 197L, 198L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           199L, 200L, 201L, 202L, 203L, 204L, 205L, 206L, 207L, 208L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           209L, 210L, 211L, 212L, 213L, 214L, 215L, 216L, 217L, 218L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           219L, 220L, 221L, 222L, 223L, 224L, 225L, 226L, 227L, 228L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           229L, 230L, 231L, 232L, 233L, 234L, 235L, 236L, 237L, 238L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           239L, 240L, 241L, 242L, 243L, 244L, 245L, 246L, 247L, 248L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           249L, 250L, 251L, 252L, 253L, 254L, 255L, 256L, 257L, 258L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           259L, 260L, 261L, 262L, 263L, 264L, 265L, 266L, 267L, 268L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           269L, 270L, 271L, 272L, 273L, 274L, 275L, 276L, 277L, 278L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           279L, 280L, 281L, 282L, 283L, 284L, 285L, 286L, 287L, 288L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           289L, 290L, 291L, 292L, 293L, 294L, 295L, 296L, 297L, 298L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           299L, 300L, 301L, 302L, 303L, 304L, 305L, 306L, 307L, 308L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           309L, 310L, 311L, 312L, 313L, 314L, 315L, 316L, 317L, 318L,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           319L, 320L, 321L, 322L, 323L, 324L), ptype = integer(0), class = c("vctrs_list_of",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              "vctrs_vctr", "list"))), row.names = c(NA, -324L), class = c("tbl_df",
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           "tbl", "data.frame")))


    expect_equivalent(df_test, df_standard)
  }

})

test_that("CAC Score ISL", {

  skip_on_cran() # due to risk of external resources failing

  file <- "https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/ISL/Season_2_2020/ISL_16102020_Budapest_Match_1.pdf"

  if(is_link_broken(file) == TRUE){
    warning("Link to external data is broken")
  } else {
    df <- file %>%
      read_results() %>%
      swim_parse_ISL()

  expect_equal(sum(unique(df[df$Team == "CAC",])$Points, na.rm = TRUE),
               567)
  }

})

test_that("Lilly King Times with score - season 2", {

  skip_on_cran() # due to risk of external resources failing

  file <- "https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/ISL/Season_2_2020/ISL_16102020_Budapest_Match_1.pdf"

  if(is_link_broken(file) == TRUE){
    warning("Link to external data is broken")
  } else {
  df <- file %>%
      read_results() %>%
      swim_parse_ISL()

  expect_equivalent(df[which(df$Name == "KING Lilly"),]$Time,
               c("2:17.11", "28.86", "1:03.16", "29.16", "29.25", "28.90"))
  }

})

test_that("Lilly King Times without score - season 1", {

  skip_on_cran() # due to risk of external resources failing

  file <- "https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/ISL/Season_1_2019/ISL_16112019_CollegePark_Day_1.pdf"

  if(is_link_broken(file) == TRUE){
    warning("Link to external data is broken")
  } else {
  df <- file %>%
    read_results() %>%
    swim_parse_ISL()

  expect_equivalent(df[which(df$Name == "KING Lilly"),]$Time,
               c("29.00", "2:17.78"))
  }

})

test_that("without score - season 1", {

  skip_on_cran() # due to risk of external resources failing

  file <- "https://github.com/gpilgrim2670/Pilgrim_Data/raw/master/ISL/Season_1_2019/ISL_16112019_CollegePark_Day_1.pdf"

  if(is_link_broken(file) == TRUE){
    warning("Link to external data is broken")
  } else {
    df_test <- file %>%
      read_results() %>%
      swim_parse_ISL(splits = TRUE, relay_swimmers =  TRUE)

    df_standard <-
      structure(
        list(
          Place = c(
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            3,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            NA,
            1,
            2,
            2,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            1,
            3,
            4,
            5,
            6,
            7,
            NA,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8,
            1,
            2,
            3,
            4,
            5,
            6,
            7,
            8
          ),
          Lane = c(
            7,
            1,
            4,
            2,
            3,
            8,
            5,
            6,
            7,
            1,
            4,
            5,
            6,
            2,
            8,
            3,
            8,
            7,
            6,
            2,
            4,
            1,
            3,
            5,
            1,
            5,
            4,
            6,
            8,
            2,
            7,
            3,
            8,
            1,
            7,
            5,
            2,
            6,
            4,
            3,
            1,
            2,
            5,
            3,
            7,
            8,
            4,
            6,
            7,
            4,
            1,
            5,
            8,
            2,
            6,
            3,
            7,
            8,
            4,
            3,
            1,
            5,
            6,
            2,
            1,
            2,
            7,
            5,
            4,
            3,
            8,
            6,
            8,
            4,
            1,
            2,
            6,
            3,
            7,
            5,
            1,
            4,
            7,
            8,
            2,
            3,
            6,
            5,
            1,
            5,
            7,
            4,
            6,
            8,
            3,
            2,
            5,
            4,
            8,
            7,
            6,
            3,
            2,
            1,
            1,
            2,
            3,
            4,
            6,
            7,
            8,
            5,
            2,
            1,
            7,
            4,
            8,
            5,
            6,
            3,
            2,
            4,
            5,
            6,
            8,
            3,
            7,
            1,
            7,
            8,
            3,
            1,
            4,
            5,
            2,
            6,
            6,
            4,
            1,
            2,
            7,
            5,
            8,
            3,
            7,
            2,
            1,
            5,
            4,
            8,
            6,
            3
          ),
          Name = c(
            "DAHLIA Kelsi",
            "STEWART Kendyl",
            "LOVEMORE Tayla",
            "OSMAN Farida",
            "BLACK Haley",
            "HINDS Natalie",
            "RULE Remedy",
            "QUAH Ting Wen",
            "DRESSEL Caeleb",
            "SHIELDS Tom",
            "LEWIS Clyde",
            "STRAVIUS Jeremy",
            "SMITH Giles",
            "CONGER Jack",
            "SWITKOWSKI Jan",
            "COETZEE Ryan",
            "KING Lilly",
            "HANNIS Molly",
            "HAUGHEY Siobhan",
            "BAKER Kathleen",
            "LARSON Breeja",
            "LAZOR Anne",
            "ESCOBEDO Emily",
            "PICKETT Leiston",
            "LIMA Felipe",
            "FINNERTY Ian",
            "ANDREW Michael",
            "CORDES Kevin",
            "FINK Nic",
            "LICON Will",
            "WILSON Andrew",
            "KOCH Marco",
            "MARGALIS Melanie",
            "EASTIN Ella",
            "FLICKINGER Hali",
            "GALAT Bethany",
            "ANDISON Bailey",
            "BARKSDALE Emma",
            "OVERHOLT Emily",
            "WOOD Abbie",
            "SELISKAR Andrew",
            "KALISZ Chase",
            "LITHERLAND Jay",
            "SMITH Brendon",
            "SZARANEK Mark",
            "IPSON Anton",
            "PERIBONIO Tomas",
            "GROTHE Zane",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "KAWECKI Radoslaw",
            "SHEBAT John",
            "THORMEYER Markus",
            "REID Christopher",
            "SHIELDS Tom",
            "HOLLARD Tristan",
            "LITHERLAND Jay",
            "CONGER Jack",
            "BAKER Kathleen",
            "BILQUIST Amy",
            "MASSE Kylie",
            "BRATTON Lisa",
            "SHERIDAN Mikkayla",
            "DELOOF Alexandra",
            "FLICKINGER Hali",
            "KUBOVA Simona",
            "DRESSEL Caeleb",
            "ANDREW Michael",
            "HELD Ryan",
            "CHADWICK Michael",
            "APPLE Zach",
            "CHIERIGHINI Marcelo",
            "BECKER Bowe",
            "HOWARD Robert",
            "GASTALDELLO Beryl",
            "BLUME Pernille",
            "WASICK Kasia",
            "SMOLIGA Olivia",
            "GEER Margo",
            "DELOOF Catherine",
            "KENNEDY Madison",
            "APOSTALON Anika",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "HAUGHEY Siobhan",
            "WILSON Madison",
            "COMERFORD Mallory",
            "MARGALIS Melanie",
            "NEALE Leah",
            "DELOOF Catherine",
            "SMITH Leah",
            "GORBENKO Anastasia",
            "PIERONI Blake",
            "SELISKAR Andrew",
            "de LUCCA Joao",
            "LEWIS Clyde",
            "STJEPANOVIC Velimir",
            "MAJCHRZAK Kacper",
            "HAAS Townley",
            "GROTHE Zane",
            "GASTALDELLO Beryl",
            "BAKER Kathleen",
            "SMOLIGA Olivia",
            "DELOOF Alexandra",
            "MASSE Kylie",
            "KUBOVA Simona",
            "COUGHLIN Natalie",
            "BLACK Haley",
            "GREVERS Matthew",
            "ANDREW Michael",
            "STRAVIUS Jeremy",
            "VAZAIOS Andreas",
            "SHEBAT John",
            "TARASEVICH Grigory",
            "KAWECKI Radoslaw",
            "RYAN Shane",
            "KING Lilly",
            "WOG Kelsey",
            "ESCOBEDO Emily",
            "LAZOR Anne",
            "LARSON Breeja",
            "GALAT Bethany",
            "ANDISON Bailey",
            "BARKSDALE Emma",
            "FINNERTY Ian",
            "KOCH Marco",
            "LICON Will",
            "PRENOT Josh",
            "FINK Nic",
            "MILLER Cody",
            "WILSON Andrew",
            "PERIBONIO Tomas",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA
          ),
          Team = c(
            "CAC",
            "LAC",
            "NYB",
            "LAC",
            "NYB",
            "CAC",
            "DCT",
            "DCT",
            "CAC",
            "LAC",
            "NYB",
            "DCT",
            "DCT",
            "LAC",
            "CAC",
            "NYB",
            "CAC",
            "CAC",
            "DCT",
            "LAC",
            "NYB",
            "LAC",
            "NYB",
            "DCT",
            "LAC",
            "DCT",
            "NYB",
            "DCT",
            "CAC",
            "LAC",
            "CAC",
            "NYB",
            "CAC",
            "LAC",
            "CAC",
            "DCT",
            "LAC",
            "DCT",
            "NYB",
            "NYB",
            "LAC",
            "LAC",
            "DCT",
            "NYB",
            "CAC",
            "CAC",
            "NYB",
            "DCT",
            "CAC",
            "NYB",
            "LAC",
            "DCT",
            "CAC",
            "LAC",
            "DCT",
            "NYB",
            "CAC",
            "CAC",
            "NYB",
            "NYB",
            "LAC",
            "DCT",
            "DCT",
            "LAC",
            "LAC",
            "LAC",
            "CAC",
            "DCT",
            "NYB",
            "NYB",
            "CAC",
            "DCT",
            "CAC",
            "NYB",
            "LAC",
            "LAC",
            "DCT",
            "NYB",
            "CAC",
            "DCT",
            "LAC",
            "NYB",
            "CAC",
            "CAC",
            "LAC",
            "NYB",
            "DCT",
            "DCT",
            "LAC",
            "DCT",
            "CAC",
            "NYB",
            "DCT",
            "CAC",
            "NYB",
            "LAC",
            "DCT",
            "NYB",
            "CAC",
            "CAC",
            "DCT",
            "NYB",
            "LAC",
            "LAC",
            "LAC",
            "LAC",
            "NYB",
            "NYB",
            "DCT",
            "CAC",
            "CAC",
            "DCT",
            "LAC",
            "LAC",
            "CAC",
            "NYB",
            "CAC",
            "DCT",
            "DCT",
            "NYB",
            "LAC",
            "NYB",
            "DCT",
            "DCT",
            "CAC",
            "NYB",
            "CAC",
            "LAC",
            "CAC",
            "CAC",
            "NYB",
            "LAC",
            "NYB",
            "DCT",
            "LAC",
            "DCT",
            "DCT",
            "NYB",
            "LAC",
            "LAC",
            "CAC",
            "DCT",
            "CAC",
            "NYB",
            "CAC",
            "LAC",
            "LAC",
            "DCT",
            "NYB",
            "CAC",
            "DCT",
            "NYB"
          ),
          Time = c(
            "55.78",
            "56.41",
            "56.93",
            "57.18",
            "57.42",
            "57.68",
            "57.95",
            "58.01",
            "49.16",
            "49.70",
            "51.13",
            "51.32",
            "51.41",
            "51.64",
            "52.12",
            "52.33",
            "29.00",
            "29.18",
            "29.88",
            "30.13",
            "30.15",
            "30.19",
            "30.40",
            "30.41",
            "25.92",
            "25.99",
            "26.09",
            "26.41",
            "26.50",
            "26.58",
            "26.84",
            "27.05",
            "4:24.46",
            "4:27.53",
            "4:29.64",
            "4:31.49",
            "4:32.01",
            "4:32.03",
            "4:32.09",
            "4:32.16",
            "4:02.88",
            "4:03.49",
            "4:04.17",
            "4:07.09",
            "4:07.81",
            "4:08.46",
            "4:11.09",
            "4:11.92",
            "3:29.38",
            "3:30.01",
            "3:30.12",
            "3:31.87",
            "3:33.23",
            "3:34.75",
            "3:37.16",
            "3:38.36",
            "1:51.68",
            "1:52.15",
            "1:52.38",
            "1:54.29",
            "1:54.50",
            "1:54.67",
            "1:55.95",
            "1:56.72",
            "2:01.57",
            "2:01.61",
            "2:01.93",
            "2:02.33",
            "2:04.59",
            "2:04.74",
            "2:05.19",
            "2:05.35",
            "20.81",
            "21.05",
            "21.39",
            "21.39",
            "21.68",
            "21.73",
            "21.86",
            "21.89",
            "23.81",
            "24.19",
            "24.23",
            "24.29",
            "24.30",
            "24.42",
            "24.54",
            "24.65",
            "3:23.63",
            "3:25.22",
            "3:26.61",
            "3:30.70",
            "3:30.74",
            "3:31.25",
            "3:37.09",
            NA,
            "1:51.99",
            "1:54.34",
            "1:54.34",
            "1:54.40",
            "1:55.75",
            "1:55.85",
            "1:56.08",
            "1:57.78",
            "1:43.48",
            "1:43.66",
            "1:43.76",
            "1:43.92",
            "1:44.12",
            "1:44.20",
            "1:45.87",
            "1:46.87",
            "26.18",
            "26.21",
            "26.32",
            "26.52",
            "26.78",
            "26.85",
            "28.29",
            "28.63",
            "23.38",
            "23.38",
            "23.49",
            "23.51",
            "23.77",
            "24.58",
            "25.04",
            NA,
            "2:17.78",
            "2:18.26",
            "2:19.26",
            "2:19.30",
            "2:22.05",
            "2:24.24",
            "2:25.55",
            "2:26.88",
            "2:02.76",
            "2:03.79",
            "2:04.09",
            "2:05.40",
            "2:06.69",
            "2:07.06",
            "2:11.09",
            "2:12.49",
            "3:08.52",
            "3:09.65",
            "3:09.81",
            "3:10.27",
            "3:10.34",
            "3:12.49",
            "3:14.69",
            "3:17.81"
          ),
          Event = c(
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Women's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Men's 100m Butterfly Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Women's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Men's 50m Breaststroke Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Women's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Men's 400m Individual Medley Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Women's 4 x 100m Freestyle Relay Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Men's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Women's 200m Backstroke Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Men's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Women's 50m Freestyle Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Men's 4 x 100m Medley Relay Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Women's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Men's 200m Freestyle Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Women's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Men's 50m Backstroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Women's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 200m Breaststroke Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final",
            "Men's 4 x 100m Freestyle Relay Final"
          ),
          DQ = c(
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            1,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            0
          ),
          Relay_Swimmer_1 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "SMOLIGA Olivia",
            "NEAL Lia",
            "TETZLOFF Alyssa",
            "APOSTALON Anika",
            "WASICK Kasia",
            "GORBENKO Anastasia",
            "KENNEDY Madison",
            "DELOOF Gabby",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "GREVERS Matthew",
            "VAZAIOS Andreas",
            "RESS Justin",
            "TARASEVICH Grigory",
            "HOLLARD Tristan",
            "KAWECKI Radoslaw",
            "REID Christopher",
            "RYAN Shane",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "DRESSEL Caeleb",
            "CARTER Dylan",
            "CHADWICK Michael",
            "HOWARD Robert",
            "THORMEYER Markus",
            "SHEBAT John",
            "STJEPANOVIC Velimir",
            "TANDY Bradley"
          ),
          Relay_Swimmer_2 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "DAHLIA Kelsi",
            "DELOOF Catherine",
            "GEER Margo",
            "HAUGHEY Siobhan",
            "MARGALIS Melanie",
            "OSMAN Farida",
            "NEALE Leah",
            "SHERIDAN Mikkayla",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "LIMA Felipe",
            "FINNERTY Ian",
            "FINK Nic",
            "KOCH Marco",
            "CORDES Kevin",
            "WILSON Andrew",
            "ANDREW Michael",
            "LICON Will",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "MAJCHRZAK Kacper",
            "RYAN Shane",
            "HELD Ryan",
            "APPLE Zach",
            "CHIERIGHINI Marcelo",
            "JACKSON Tate",
            "SMITH Giles",
            "REID Christopher"
          ),
          Relay_Swimmer_3 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "HINDS Natalie",
            "BLUME Pernille",
            "MACK Linnea",
            "RASMUS Claire",
            "WEIR Amanda",
            "BANIC Maddie",
            "COUGHLIN Natalie",
            "BLACK Haley",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "SHIELDS Tom",
            "STRAVIUS Jeremy",
            "DRESSEL Caeleb",
            "COETZEE Ryan",
            "SMITH Giles",
            "SWITKOWSKI Jan",
            "DARRAGH Mackenzie",
            "PRENOT Josh",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "BECKER Bowe",
            "GREVERS Matthew",
            "PIERONI Blake",
            "VAZAIOS Andreas",
            "SPAJARI Pedro",
            "HAAS Townley",
            "GROTHE Zane",
            "COETZEE Ryan"
          ),
          Relay_Swimmer_4 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "COMERFORD Mallory",
            "WILSON Madison",
            "GASTALDELLO Beryl",
            "QUAH Ting Wen",
            "WOG Kelsey",
            "STEWART Kendyl",
            "GIBSON Sarah",
            "LOVEMORE Tayla",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "CHADWICK Michael",
            "APPLE Zach",
            "JACKSON Tate",
            "SPAJARI Pedro",
            "HOWARD Robert",
            "HAAS Townley",
            "CHIERIGHINI Marcelo",
            "CARTER Dylan",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "RESS Justin",
            "SELISKAR Andrew",
            "SHIELDS Tom",
            "STRAVIUS Jeremy",
            "LEWIS Clyde",
            "SWITKOWSKI Jan",
            "HOLLARD Tristan",
            "de LUCCA Joao"
          ),
          Split_50 = c(
            "26.36",
            "26.03",
            "26.27",
            "26.58",
            "26.82",
            "26.72",
            "26.90",
            "26.90",
            "23.41",
            "23.13",
            "24.52",
            "23.44",
            "23.69",
            "23.98",
            "24.29",
            "24.44",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "28.78",
            "29.00",
            "28.74",
            "28.59",
            "30.23",
            "29.31",
            "28.50",
            "28.25",
            "25.78",
            "25.80",
            "26.35",
            "26.54",
            "25.92",
            "26.96",
            "26.69",
            "26.71",
            "25.36",
            "25.65",
            "25.55",
            "25.88",
            "25.70",
            "26.04",
            "25.56",
            "26.17",
            "25.86",
            "26.02",
            "26.53",
            "26.57",
            "26.65",
            "26.13",
            "27.46",
            "27.42",
            "28.59",
            "29.27",
            "28.76",
            "29.47",
            "29.25",
            "29.29",
            "30.13",
            "29.54",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "24.05",
            "24.55",
            "24.75",
            "24.99",
            "25.94",
            "25.42",
            "25.73",
            "24.39",
            "26.11",
            "26.77",
            "27.02",
            "27.76",
            "27.50",
            "27.51",
            "27.19",
            "27.04",
            "24.09",
            "23.91",
            "24.19",
            "23.90",
            "24.06",
            "23.90",
            "24.45",
            "24.58",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "30.80",
            "31.54",
            "32.42",
            "32.37",
            "31.89",
            "33.25",
            "33.05",
            "33.19",
            "27.20",
            "28.82",
            "28.22",
            "28.60",
            "28.79",
            "28.24",
            "29.03",
            "29.59",
            "22.06",
            "22.71",
            "22.48",
            "23.23",
            "22.78",
            "23.44",
            "23.81",
            "22.38"
          ),
          Split_100 = c(
            "29.42",
            "30.38",
            "30.66",
            "30.60",
            "30.60",
            "30.96",
            "31.05",
            "31.11",
            "25.75",
            "26.57",
            "26.61",
            "27.88",
            "27.72",
            "27.66",
            "27.83",
            "27.89",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "32.17",
            "32.00",
            "32.06",
            "32.30",
            "33.53",
            "32.69",
            "32.27",
            "32.50",
            "30.25",
            "29.50",
            "29.70",
            "30.24",
            "29.97",
            "30.69",
            "30.54",
            "30.34",
            "52.99",
            "53.28",
            "53.45",
            "53.82",
            "53.32",
            "53.66",
            "53.85",
            "54.50",
            "27.95",
            "28.60",
            "28.64",
            "28.48",
            "29.75",
            "28.45",
            "29.29",
            "29.21",
            "30.97",
            "30.70",
            "31.35",
            "31.17",
            "31.97",
            "30.86",
            "31.84",
            "31.96",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "50.16",
            "51.39",
            "51.58",
            "52.13",
            "53.42",
            "53.20",
            "54.54",
            "50.84",
            "28.08",
            "28.74",
            "28.71",
            "29.08",
            "29.46",
            "28.96",
            "29.19",
            "29.72",
            "26.46",
            "26.20",
            "26.47",
            "26.36",
            "26.21",
            "26.72",
            "26.63",
            "26.72",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "36.02",
            "34.94",
            "35.80",
            "35.47",
            "36.46",
            "36.26",
            "37.45",
            "37.01",
            "30.66",
            "31.85",
            "31.36",
            "31.73",
            "32.42",
            "32.48",
            "32.85",
            "33.15",
            "46.21",
            "47.69",
            "47.25",
            "48.37",
            "47.40",
            "48.47",
            "49.29",
            "48.68"
          ),
          Split_150 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "35.37",
            "33.49",
            "35.49",
            "35.92",
            "35.73",
            "35.10",
            "35.06",
            "35.74",
            "31.83",
            "31.36",
            "30.94",
            "31.66",
            "31.62",
            "31.99",
            "32.44",
            "32.72",
            "24.80",
            "25.10",
            "24.51",
            "24.80",
            "25.36",
            "25.41",
            "25.75",
            "25.42",
            "28.90",
            "28.89",
            "28.75",
            "29.21",
            "29.31",
            "29.77",
            "29.13",
            "30.35",
            "30.82",
            "31.09",
            "31.20",
            "31.01",
            "32.10",
            "32.11",
            "32.04",
            "32.02",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "26.09",
            "25.71",
            "26.71",
            "27.35",
            "26.97",
            "27.10",
            "27.15",
            NA,
            "28.73",
            "29.70",
            "29.09",
            "29.09",
            "29.71",
            "29.69",
            "29.96",
            "30.39",
            "26.51",
            "26.75",
            "26.45",
            "26.74",
            "26.64",
            "27.07",
            "27.26",
            "28.27",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "36.42",
            "35.39",
            "35.45",
            "36.00",
            "36.41",
            "37.12",
            "37.90",
            "37.80",
            "31.79",
            "31.56",
            "32.32",
            "32.37",
            "32.73",
            "32.89",
            "34.20",
            "34.37",
            "22.88",
            "22.28",
            "22.35",
            "22.43",
            "22.69",
            "22.87",
            "22.71",
            "23.29"
          ),
          Split_200 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "34.94",
            "33.28",
            "33.85",
            "34.25",
            "33.68",
            "34.73",
            "33.73",
            "34.83",
            "31.21",
            "30.38",
            "30.23",
            "30.61",
            "32.04",
            "30.73",
            "32.30",
            "31.78",
            "52.31",
            "52.59",
            "51.99",
            "51.41",
            "52.67",
            "53.59",
            "53.39",
            "53.07",
            "28.97",
            "28.64",
            "28.46",
            "30.03",
            "28.79",
            "30.32",
            "30.07",
            "29.74",
            "31.19",
            "30.55",
            "30.62",
            "30.68",
            "31.27",
            "32.48",
            "31.18",
            "31.83",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "56.54",
            "56.13",
            "57.68",
            "58.02",
            "58.16",
            "58.41",
            "59.51",
            NA,
            "29.07",
            "29.13",
            "29.52",
            "28.47",
            "29.08",
            "29.69",
            "29.74",
            "30.63",
            "26.42",
            "26.80",
            "26.65",
            "26.92",
            "27.21",
            "26.51",
            "27.53",
            "27.30",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "34.54",
            "36.39",
            "35.59",
            "35.46",
            "37.29",
            "37.61",
            "37.15",
            "38.88",
            "33.11",
            "31.56",
            "32.19",
            "32.70",
            "32.75",
            "33.45",
            "35.01",
            "35.38",
            "47.55",
            "47.29",
            "47.67",
            "47.04",
            "48.17",
            "48.23",
            "48.09",
            "49.18"
          ),
          Split_250 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "35.76",
            "37.50",
            "39.63",
            "38.01",
            "38.26",
            "38.21",
            "39.51",
            "38.06",
            "34.12",
            "33.49",
            "35.06",
            "36.00",
            "33.90",
            "35.00",
            "34.38",
            "37.00",
            "25.11",
            "24.63",
            "24.85",
            "26.07",
            "25.78",
            "25.30",
            "26.19",
            "26.69",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "16.03",
            "23.38",
            "23.03",
            "24.85",
            "23.64",
            "24.32",
            "24.88",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "22.35",
            "22.26",
            "22.49",
            "22.57",
            "22.61",
            "22.69",
            "23.14",
            "23.82"
          ),
          Split_300 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "36.77",
            "38.41",
            "39.59",
            "38.92",
            "38.70",
            "39.39",
            "40.26",
            "38.76",
            "34.14",
            "34.62",
            "35.43",
            "36.45",
            "35.61",
            "36.04",
            "35.54",
            "38.03",
            "52.40",
            "52.22",
            "52.81",
            "53.99",
            "54.02",
            "54.44",
            "55.23",
            "55.86",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "49.73",
            "51.07",
            "49.54",
            "53.08",
            "51.23",
            "52.53",
            "53.42",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "47.45",
            "47.31",
            "47.92",
            "46.92",
            "47.73",
            "47.47",
            "48.14",
            "50.42"
          ),
          Split_350 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "30.64",
            "32.13",
            "30.69",
            "32.61",
            "31.77",
            "31.95",
            "32.07",
            "32.62",
            "28.41",
            "29.89",
            "29.26",
            "28.54",
            "29.79",
            "29.08",
            "29.89",
            "28.29",
            "24.71",
            "25.05",
            "24.64",
            "24.73",
            "25.50",
            "25.05",
            "25.68",
            "26.01",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "22.44",
            "22.10",
            "21.99",
            "22.24",
            "22.72",
            "22.16",
            "23.12",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "22.82",
            "22.68",
            "22.56",
            "22.77",
            "22.45",
            "23.21",
            "23.56",
            "23.73"
          ),
          Split_400 = c(
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "30.03",
            "31.72",
            "29.59",
            "30.89",
            "30.11",
            "30.65",
            "30.69",
            "31.40",
            "27.14",
            "28.45",
            "27.20",
            "27.05",
            "28.96",
            "27.97",
            "29.31",
            "27.05",
            "51.68",
            "51.92",
            "51.87",
            "52.65",
            "53.22",
            "53.06",
            "54.69",
            "54.93",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "47.20",
            "46.63",
            "47.81",
            "47.47",
            "47.93",
            "47.11",
            "49.62",
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            NA,
            "47.31",
            "47.36",
            "46.97",
            "47.94",
            "47.04",
            "48.32",
            "49.17",
            "49.53"
          )
        ),
        row.names = c(NA,-152L),
        class = c("rowwise_df", "tbl_df",
                  "tbl", "data.frame"),
        groups = structure(
          list(.rows = structure(
            list(
              1L,
              2L,
              3L,
              4L,
              5L,
              6L,
              7L,
              8L,
              9L,
              10L,
              11L,
              12L,
              13L,
              14L,
              15L,
              16L,
              17L,
              18L,
              19L,
              20L,
              21L,
              22L,
              23L,
              24L,
              25L,
              26L,
              27L,
              28L,
              29L,
              30L,
              31L,
              32L,
              33L,
              34L,
              35L,
              36L,
              37L,
              38L,
              39L,
              40L,
              41L,
              42L,
              43L,
              44L,
              45L,
              46L,
              47L,
              48L,
              49L,
              50L,
              51L,
              52L,
              53L,
              54L,
              55L,
              56L,
              57L,
              58L,
              59L,
              60L,
              61L,
              62L,
              63L,
              64L,
              65L,
              66L,
              67L,
              68L,
              69L,
              70L,
              71L,
              72L,
              73L,
              74L,
              75L,
              76L,
              77L,
              78L,
              79L,
              80L,
              81L,
              82L,
              83L,
              84L,
              85L,
              86L,
              87L,
              88L,
              89L,
              90L,
              91L,
              92L,
              93L,
              94L,
              95L,
              96L,
              97L,
              98L,
              99L,
              100L,
              101L,
              102L,
              103L,
              104L,
              105L,
              106L,
              107L,
              108L,
              109L,
              110L,
              111L,
              112L,
              113L,
              114L,
              115L,
              116L,
              117L,
              118L,
              119L,
              120L,
              121L,
              122L,
              123L,
              124L,
              125L,
              126L,
              127L,
              128L,
              129L,
              130L,
              131L,
              132L,
              133L,
              134L,
              135L,
              136L,
              137L,
              138L,
              139L,
              140L,
              141L,
              142L,
              143L,
              144L,
              145L,
              146L,
              147L,
              148L,
              149L,
              150L,
              151L,
              152L
            ),
            ptype = integer(0),
            class = c("vctrs_list_of",
                      "vctrs_vctr", "list")
          )),
          row.names = c(NA,-152L),
          class = c("tbl_df",
                    "tbl", "data.frame")
        )
      )


    expect_equivalent(df_test, df_standard)
  }

})

# testthat::test_file("tests/testthat/test-ISL.R")
