% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mode.R
\name{get_mode}
\alias{get_mode}
\title{Find the mode (most commonly occurring) element of a list}
\usage{
get_mode(x, type = "first")
}
\arguments{
\item{x}{A list.  \code{NA} elements will be ignored.}

\item{type}{a character string of either \code{"first"} or \code{"all"} which
determines behavior for ties.  Setting \code{type = "first"} (the default)
will return the element that appears most often and appears first in list
\code{x}.  Setting \code{type = "all"} will return all elements that appear
most frequently.}
}
\value{
the element of \code{x} which appears most frequently.  Ties go to
  the lowest index, so the element which appears first.
}
\description{
Determines which element of list appears most frequently.  Based on
\code{base::which.max()}, so if multiple values appear with the same
frequency will return the first one.  Ignores \code{NA} values. In the
context of swimming data is often used to clean team names, as in the Lilly
King example below.
}
\examples{
a <- c("a", "a", "b", "c")
get_mode(a)
ab <- c("a", "a", "b", "b", "c") # returns "a", not "b"
get_mode(ab)
#' ab <- c("a", "a", "b", "b", "c") # returns "a" and "b"
get_mode(ab, type = "all")
a_na <- c("a", "a", NA, NA, "c")
get_mode(a_na)
numbs <- c(1, 1, 1, 2, 2, 2, 3, NA)
get_mode(numbs, type = "all")

Name <- c(rep("Lilly King", 5))
Team <- c(rep("IU", 2), "Indiana", "IUWSD", "Indiana University")
df <- data.frame(Name, Team, stringsAsFactors = FALSE)
df$Team <- get_mode(df$Team)

}
