% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChiSq_variable.R
\name{ChiSq_variable}
\alias{ChiSq_variable}
\title{Chi squared variable from point table.}
\usage{
ChiSq_variable(base, IndK, PointTable, interactive = TRUE, ylim = 0.09)
}
\arguments{
\item{base}{Data set}

\item{IndK}{Character with the name of the column that specifies the partition of the data set in k tables.}

\item{PointTable}{Table indicator. A character or number that is part of the \code{IndK} registers. This argument specifies the table to which the analysis will be performed.}

\item{interactive}{If it is TRUE, the graph will be shown interactively. If FALSE, the graph is displayed flat. FALSE is the default.}

\item{ylim}{y-axis limit.}
}
\value{
A table with Chi square distances between the column masses of the table specified in \code{PointTable} and the concatenated table.
}
\description{
Contains Chi square distance between the column masses of the table specified in \code{PointTable} and the concatenated table. It allows to identify which mode is responsible for the anomaly in the table in which it is located.
}
\examples{
data(Datak10Contaminated)
ChiSq_variable(Datak10Contaminated, "GroupLetter", PointTable="j", ylim=5, interactive=TRUE)
}
