% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{nested.cv}
\alias{nested.cv}
\title{Estimating predictive performance via nested cross-validation}
\usage{
nested.cv(x, y, upstream, method, family = "gaussian", nfolds = 10,
  nfolds_inner = 10, foldid = NULL, ...)
}
\arguments{
\item{x}{A feature matrix, where the rows correspond to samples and the columns to features.}

\item{y}{A vector containing the response.}

\item{upstream}{A logical index vector that indicates for each feature whether it's upstream (TRUE) or downstream (FALSE).}

\item{method}{Indicates whether the nested cross-validation is performed on TANDEM or on the classic approach (glmnet). Should be either "tandem" or "glmnet".}

\item{family}{The family parameter that's passed to cv.glmnet(). Currently, only family='gaussian' is supported.}

\item{nfolds}{Number of cross-validation folds (default is 10) used in the outer cross-validation loop.}

\item{nfolds_inner}{Number of cross-validation folds (default is 10) used to determine the optimal lambda in the inner cross-validation loop.}

\item{foldid}{An optional vector indicating in which cross-validation fold each sample should be in the outer cross-validation loop. Overrides nfolds when used.}

\item{...}{Other parameters that are passed to cv.glmnet().}
}
\value{
The predicted response vector y_hat and the mean-squared error (MSE).
}
\description{
Performs a nested cross-validation to assess the predictive performance. The inner loop is used to determine the optimal lambda
(as in cv.glmnet) and the outer loop is used to asses the predictive performance in an unbiased way.
}
\examples{
# unpack example data
x = example_data$x
y = example_data$y
upstream = example_data$upstream

# assess the prediction error in a nested cv-loop
# fix the seed to have the same foldids between the two methods
set.seed(1)
cv_tandem = nested.cv(x, y, upstream, method="tandem", alpha=0.5)
set.seed(1)
cv_glmnet = nested.cv(x, y, upstream, method="glmnet", alpha=0.5)
barplot(c(cv_tandem$mse, cv_glmnet$mse), ylab="MSE", names=c("TANDEM", "Classic approach"))
}

