% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TBF_ingredients.R
\name{TBF_ingredients}
\alias{TBF_ingredients}
\title{Ingredients to calculate the TBF}
\usage{
TBF_ingredients(fullModel, data, discreteSurv = FALSE, numberCores = 1,
  candidateModels = NULL, package = "nnet", maxit = 150)
}
\arguments{
\item{fullModel}{formula of the model including all potential variables}

\item{data}{the data frame with all the information}

\item{discreteSurv}{Boolean variable telling us whether a 'simple'
multinomial regression is looked for or if the goal is a discrete
survival-time model for multiple modes of failure is needed.}

\item{numberCores}{How many cores should be used in parallel?}

\item{candidateModels}{Instead of defining the full model we can also
specify the candidate models whose deviance statistic and d.o.f should be
computed}

\item{package}{Which package should be used to fit the models; by default
the \code{nnet} package is used; we could also specify to use the package
'VGAM'}

\item{maxit}{Only needs to be specified with package \code{nnet}: maximal
number of iterations}
}
\value{
an object of class \code{TBF.ingredients}
}
\description{
This function calculates the ingredients needed to
compute the TBFs: like the deviances with their degrees of freedom of the
relevant candidate models.
}
\author{
Rachel Heyard
}
