\name{TCC-class}
\docType{class}
\alias{TCC-class}
\title{A container for storing information used in TCC}
\description{
This is the container class for TCC. This class initially contains 
count data matrix and some information for the analysis of count data. 
It also provides further fields that are populated during the analysis.
}
\details{
This class is implemented as a R5 reference class.
Thus the method call to this class object change the content of the
object. Functions calling such methods copies the object prior to
calling the method to keep the semantics of functional programming.
This class can be created by the generic \code{new()} function with 
the data for (i.e., \code{count} and \code{group}) fields. 
Information of the (\code{replicates}) field can automatically be obtained 
when creating this class object from the information of the \code{group} field. 
Alternatively, if you supply the \code{replicates}, the group field can be
filled automatically.

The values (defaults to all 1) in the \code{norm.factors} field 
will be changed after performing the \code{\link{calcNormFactors}} function.
The \code{stat} field stores (i) execution time for calculating normalization
factors after performing the \code{\link{calcNormFactors}} function,
and (iii) statistics (i.e., \eqn{p}-value, \eqn{q}-value, and rank)
related to the degrees of differential expression for individual genes
after performing the \code{\link{estimateDE}} function. 
The \code{estimatedDEG} field stores information about 
which genes are called significantly highly expressed in one group.
The threshold for determining the differentially expressed genes (DEGs) 
is preliminarily indicated when performing the \code{\link{estimateDE}} function. 
The \code{simulation} field stores parameters of the simulation.
The information in this field is generated by the 
\code{\link{generateSimulationData}} function.
}
\section{Fields}{
This class contains the following fields:
	\describe{
		\item{count}{numeric matrix containing count data. }
		\item{group}{numeric vector indicating the numbers of
		 replicates for individual groups compared.}
		\item{replicates}{numeric vector indicating the 
		 experimental group for each sample (or library).}
		\item{norm.factors}{numeric vector containing
		 normalization factors.}
		\item{stat}{list for storing results after the execution
		 of the \code{\link{calcNormFactors}} and
		 \code{\link{estimateDE}} functions.}
		\item{estimatedDEG}{numeric vector as a placeholder for
		 indicating which genes are expressed higher in particular
		 group compared to the others.  The values in this field
		 will be populated after the execution of the
		 \code{\link{estimateDE}} function.}
		\item{simulation}{list. This field is only used for
		 analyzing simulation data.}
	}
}
\examples{
\dontrun{
tcc <- generateSimulationData()

# Check the counts.
tcc$count

# Check the group and replicates annotation of counts.
tcc$group
tcc$replicates

# Check the normalization factors.
tcc <- calcNormFactors(tcc)
tcc$norm.factors

# Check the p-values and q-values.
tcc <- estimateDE(tcc)
head(tcc$stat$p.value)
head(tcc$stat$q.value)

# Compare the breakdowns of estimated DEGs with the truth.
head(tcc$estimatedDEG)
head(tcc$simulation$trueDEG)

# M-A plotting.
plot(tcc)
}
}
\keyword{classes}
