% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussSmoothArray.R
\name{GaussSmoothArray}
\alias{GaussSmoothArray}
\title{GaussSmoothArray}
\usage{
GaussSmoothArray(
  x,
  voxdim = c(1, 1, 1),
  ksize = 5,
  sigma = diag(3, 3),
  mask = NULL,
  var.norm = FALSE
)
}
\arguments{
\item{x}{The array to be smoothed.}

\item{voxdim}{The dimensions of the volume elements (voxel) that make up the array.}

\item{ksize}{The dimensions (in number of voxels) of the 3D discrete smoothing kernel used to smooth the array.}

\item{sigma}{The covariance matrix of the 3D Gaussian smoothing kernel. This matrix doesn't have to be non-singular; zero on the diagonal of sigma indicate no smoothing in that direction.}

\item{mask}{A 3D 0-1 mask that delimits where the smoothing occurs.}

\item{var.norm}{Logical flag indicating whether to normalize the variance of the smoothed array.}
}
\description{
An internal function named GaussSmoothArray. Original from AnalyzeFMRI package
}
