% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_spatial_information.R
\name{extract_spatial_information}
\alias{extract_spatial_information}
\title{Extract distances and surface areas from a spatial object}
\usage{
extract_spatial_information(geometry, id = NULL, show_progress = FALSE)
}
\arguments{
\item{geometry}{a spatial object that can be handled by the \code{sf} package.}

\item{id}{name or number of the column to use as rownames and colnames for
the output distance matrix (optional, NULL by default). A vector with length
equal to the number of locations can also be used.}

\item{show_progress}{a boolean indicating if a progress bar should be
displayed.}
}
\value{
A list composed of two elements. The first element is a squared matrix
representing the great-circle distance (in kilometer) between locations. The
second element is a vector containing the surface area of each location
(in square kilometer).
}
\description{
This function returns a matrix of distances between locations (in kilometer)
along with a vector surface areas of the locations (in square kilometer).
}
\details{
The \code{geometry} must be projected in a valid coordinate reference
system. It will be reprojected in degrees longitude/latitude to compute the
great-circle distances between centroids' locations with an internal function
and to compute the surface area with the function \link[sf:geos_measures]{st_area} from
the \href{https://cran.r-project.org/package=sf}{sf} package.
}
\note{
The outputs are based on the locations contained in \code{geometry} and
sorted in the same order. An optional \code{id} can also be provided to be used as
names for the outputs.
}
\examples{
data(county)

res <- extract_spatial_information(county, id = "ID")

dim(res$distance)

length(res$surface)

}
\seealso{
\code{\link[=calib_param]{calib_param()}} \code{\link[=extract_opportunities]{extract_opportunities()}} \code{\link[=check_format_names]{check_format_names()}}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
