% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdmModelingUtils.r
\name{tdmModSortedRFimport}
\alias{tdmModSortedRFimport}
\title{Sort the input variables decreasingly by their RF-importance.}
\usage{
tdmModSortedRFimport(d_train, response.variable, input.variables, opts)
}
\arguments{
\item{d_train}{training set}

\item{response.variable}{the target column from \code{d_train} to use for the RF-model}

\item{input.variables}{the input columns from \code{d_train} to use for the RF-model}

\item{opts}{options, here we use the elements [defaults in brackets]:
\itemize{
 \item SRF.kind:  \cr
      ="xperc": keep a certain importance percentage, starting from the most important variable \cr
      ="ndrop": drop a certain number of least important variables \cr
      ="nkeep": keep a certain number of most important variables \cr
      ="none": do not call \code{\link{tdmModSortedRFimport}} at all (see tdmRegress.r and tdmClassify.r)
 \item SRF.ndrop:   [0] how many variables to drop (if SRF.kind=="ndrop")
 \item SRF.XPerc:   [0.95] if >=0, keep that importance percentage, starting with the most
               important variables (if SRF.kind=="xperc")
 \item SRF.calc:    [TRUE] =TRUE: calculate importance & save on SRF.file, =F: load from SRF.file
               (SRF.file = Output/<filename>.SRF.<response.variable>.Rdata)
 \item SRF.ntree:   [50] number of RF trees
 \item SRF.verbose: [2]
 \item SRF.maxS:    [40] how many variables to show in plot
 \item SRF.minlsi:  [1] a lower bound for the length of SRF$input.variables
 \item RF.sampsize: sampsize for RF, set prior to calling this func via tdmModAdjustSampsize(opts$SRF.samp,...)
 \item GD.DEVICE:   if !="non", then make a bar plot on current graphic device
 \item CLS.CLASSWT: class weight vector to use in random forest training
}}
}
\value{
\code{SRF},    a list with the following elements:
    \item{input.variables}{   the vector of input variables which remain after importance
                   processing. These are sorted by decreasing importance.}
    \item{s_input}{all input.variables sorted by decreasing (**NEW**) importance}
    \item{s_imp1}{ the importance for s_input}
    \item{s_dropped}{   vector with name of dropped variables}
    \item{lsd}{    length of s_dropped}
    \item{perc}{   the percentage of total importance which is in the dropped variables}
    \item{opts}{   some defaults might have been added}
}
\description{
Build a Random Forest using \code{importance=TRUE}. Usually the RF is smaller (50 trees), to speed up computation.
      Use na.roughfix for missing value replacement.
      Decide which input variables to keep and return them in SRF$input.variables
}
\author{
Wolfgang Konen, Patrick Koch \email{wolfgang.konen@th-koeln.de}
}

