% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdmRegressLoop.r
\name{tdmRegressLoop}
\alias{TDMregressor}
\alias{tdmRegressLoop}
\title{Core regression double loop of TDMR returning a \code{\link{TDMregressor}} object.}
\usage{
tdmRegressLoop(dset, response.variables, input.variables, opts, tset = NULL)
}
\arguments{
\item{dset}{the data frame for which cvi is needed}

\item{response.variables}{name of column which carries the target variable - or -
vector of names specifying multiple target columns
(these columns are not used during prediction, only for training and
for evaluating the predicted result)}

\item{input.variables}{vector with names of input columns}

\item{opts}{a list from which we need here the following entries
\describe{
  \item{\code{NRUN}}{ number of runs (outer loop)}
  \item{\code{TST.SEED}}{ =NULL: leave the random number seed as it is. =any value: set the random number seed
          to this value to get reproducible random numbers and thus reproducible training-test-set-selection.
          (only relevant in case TST.kind=="cv" or "rand") (see also MOD.SEED in \code{\link{tdmClassify}})}
  \item{\code{TST.kind}}{ how to create cvi, handed over to \code{\link{tdmModCreateCVindex}}. If TST.kind="col", then cvi is taken from dset[,opts$TST.col].}
  \item{\code{GD.RESTART}}{ [TRUE] =TRUE/FALSE: do/don't restart graphic devices}
  \item{\code{GRAPHDEV}}{ ["non"| other ]}
}}

\item{tset}{[NULL] If not NULL, this is the test data set. If NULL, we are in tuning and the validation data 
set is build from \code{dset} according to the procedure prescribed in \code{opts$TST.*}.}
}
\value{
\code{result},  an object of class \code{\link{TDMregressor}}, this is a list with results, containing
      \item{opts}{ the res$opts from \code{\link{tdmRegress}}}
      \item{lastRes}{ last run, last fold: result from \code{\link{tdmRegress}}}
      \item{R_train}{ RMAE / RMSE on training set (vector of length NRUN), depending on opts$rgain.type=="rmae" or "rmse"}
      \item{S_train}{ RMSE on training set (vector of length NRUN)}
      \item{T_train}{ Theil's U for RMAE on training set (vector of length NRUN)}
      \item{*_test}{ --- similar, with test set instead of training set ---  }
      \item{Err}{ a data frame with as many rows as opts$NRUN and columns = (rmae.trn, rmse.trn
                  made.trn, rmae.theil.trn, ntrn, rmae.tst, rmse.tst, made.tst, rmae.theil.tst,
                  ntst) }
      \item{predictions}{ last run: data frame with dimensions [nrow(dset),length(response.variable)]. In case of CV, all 
             validation set predictions (for each record in dset), in other cases mixed validation / train set predictions.  }
      \item{predictTest}{ predictions on the test set \code{tset} (NULL if \code{tset==NULL} )}
}
\description{
tdmRegressLoop contains a double loop (opts$NRUN and CV-folds)
and calls \code{\link{tdmRegress}}. It is called  by all R-functions main_*. \cr
It returns an object of class \code{\link{TDMregressor}}.
}
\examples{
#*# --------- demo/demo00-1regress.r ---------
#*# This demo shows a simple data mining process (phase 1 of TDMR) for regression on
#*# dataset iris.
#*# The data mining process in tdmRegressLoop calls randomForest as the prediction model.
#*# It is called opts$NRUN=2 times with different random train-validation set splits.
#*# Therefore data frame result$Err has 2 rows.
#*#
opts=tdmOptsDefaultsSet()                       # set all defaults for data mining process
gdObj <- tdmGraAndLogInitialize(opts);          # init graphics and log file

data(iris)
response.variables="Petal.Length"                # names, not data (!)
input.variables=setdiff(names(iris),"Petal.Length")
opts$rgain.type="rmae"

result = tdmRegressLoop(iris,response.variables,input.variables,opts)

print(result$Err)
}
\author{
Wolfgang Konen (\email{wolfgang.konen@th-koeln.de}), THK
}
\seealso{
\code{\link{tdmRegress}}, \code{\link{tdmClassifyLoop}}, \code{\link{tdmClassify}}
}

