% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdmEnvTMakeNew.r
\name{tdmEnvTMakeNew}
\alias{tdmEnvTMakeNew}
\alias{TDMenvir}
\title{Construct a new environment envT of class \code{\link{TDMenvir}}.}
\usage{
tdmEnvTMakeNew(tdm = NULL, sCList = defaultSCList())
}
\arguments{
\item{tdm}{a list with general settings for TDMR, see \code{\link{tdmDefaultsFill}}}

\item{sCList}{[defaultSC()] a list of list with controls for SPOT or other tuners (one list
for each element in \code{tdm$runList})}
}
\value{
Environment \code{envT},  an object of class \code{\link{TDMenvir}},  containing (among others) the elements
     \item{\code{runList}}{ \code{=tdm$runList}  }
     \item{\code{tdm}}{ \code{=\link{tdmDefaultsFill}(tdm)}  }
     \item{\code{getBst}}{ accessor function(confFile,nExp,theTuner) into \code{envT$bstGrid}   }
     \item{\code{getRes}}{ accessor function(confFile,nExp,theTuner) into \code{envT$resGrid}   }
     \item{\code{sCList}}{ list of spotConfig-objects, as many as \code{envT$runList} has elements. Each spotConfig object 
         \code{sCList[[k]]} contains a list \code{opts} as element for the machine learning part.  }
}
\description{
Given the general TDMR settings in \code{tdm}, construct an appropriate environment \code{envT}.
This is needed as input for \code{\link{tdmBigLoop}}.
}
\seealso{
\code{\link{tdmBigLoop}}
}
\author{
Wolfgang Konen (\email{wolfgang.konen@th-koeln.de}), THK, Patrick Koch
}
