% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_cov.R
\name{est_cov}
\alias{est_cov}
\alias{est_cov.PWMs}
\alias{est_cov.TLMoments}
\alias{est_cov.parameters}
\alias{est_cov.quantiles}
\title{Calculation of the covariance matrix of estimations of PWMs, TLMoments, parameters, or quantiles}
\usage{
est_cov(x, ...)

\method{est_cov}{PWMs}(x, order = attr(x, "order"), ...)

\method{est_cov}{TLMoments}(x, leftrim = attr(x, "leftrim"),
  rightrim = attr(x, "rightrim"), order = attr(x, "order"), ...)

\method{est_cov}{parameters}(x, distr = attr(x, "distribution"),
  leftrim = attr(x, "source")$trimmings[1], rightrim = attr(x,
  "source")$trimmings[2], ...)

\method{est_cov}{quantiles}(x, distr = attr(x, "distribution"), p = attr(x,
  "p"), leftrim = attr(x, "source")$trimmings[1], rightrim = attr(x,
  "source")$trimmings[2], ...)
}
\arguments{
\item{x}{object of \code{PWMs}, \code{TLMoments}, \code{parameters},
or \code{quantiles} constructed using the same-named functions.}

\item{...}{additional arguments given to the sub-functions. Normally not necessary.}

\item{order}{numeric vector giving the orders of PWMs or TLMoments, if \code{est_cov} is calculated from
\code{PWMs} or \code{TLMoments}.}

\item{leftrim, rightrim}{lower and upper trimming parameter, if \code{est_cov} is calculated from \code{TLMoments}.}

\item{distr}{character giving the distribution, if \code{est_cov} is calculated with parametric assumption.}

\item{p}{numeric vector giving the quantile estimates from which the covariance should be calculated, if \code{est_cov}
is calculated from \code{quantiles}.}
}
\value{
a numeric matrix (if \code{x} is of class \code{PWMs}, \code{parameters}, or
         \code{quantiles}) or a list of two matrices (\code{lambdas} and \code{ratios}, if
         \code{x} is of class \code{TLMoments}).
}
\description{
description not done yet
}
\examples{
### 1: PWMs:

x <- evd::rgev(100, shape = .1)

est_cov(PWMs(x))
est_cov(PWMs(x), order = 1:2)

est_cov(PWMs(x), distr = "gev") # parametric with gev assumption

x <- cbind(evd::rgev(100, shape = .1), evd::rgev(100, shape = .3))
est_cov(PWMs(x))
est_cov(PWMs(x), order = 0:1)
#cov(t(replicate(100000,
# as.vector(PWMs(cbind(evd::rgev(100, shape = .1), evd::rgev(100, shape = .3)), 1)))
#))

### 2. TLMoments:

x <- evd::rgev(100, shape = .1)

est_cov(TLMoments(x))
est_cov(TLMoments(x, rightrim = 1))
est_cov(TLMoments(x), order = 1:2)

est_cov(TLMoments(x), distr = "gev") # parametric with gev assumption

x <- cbind(evd::rgev(100, shape = .1), evd::rgev(100, shape = .3))
est_cov(TLMoments(x))

para <- as.parameters(loc = 10, scale = 5, shape = .2, distr = "gev")
est_cov(TLMoments(para, rightrim = 0), distr = "gev", set.n = 100)
est_cov(TLMoments(para, rightrim = 1), distr = "gev", set.n = 100)

### 3. Parameters:

x <- evd::rgev(100, shape = .1)

est_cov(parameters(TLMoments(x), "gev")) # default parametric
est_cov(parameters(TLMoments(x, rightrim = 1), "gev"))

est_cov(parameters(TLMoments(x), "gev"), np.cov = TRUE) # explicit non-parametric
est_cov(parameters(TLMoments(x, rightrim = 1), "gev"), np.cov = TRUE)

x <- cbind(evd::rgev(100, shape = .1), evd::rgev(100, shape = .3))
est_cov(parameters(TLMoments(x), "gev"))

para <- as.parameters(loc = 10, scale = 5, shape = .2, distr = "gev")
est_cov(para, set.n = 100)
est_cov(para, rightrim = 1, set.n = 100)

# var(replicate(1000, parameters(TLMoments(evd::rgev(100, 10, 5, .2)), "gev")[1]))
# var(replicate(1000, parameters(TLMoments(evd::rgev(100, 10, 5, .2), rightrim = 1), "gev")[1]))

### 4. Quantiles:

library(evd)
x <- evd::rgev(100, shape = .2)

q <- quantiles(parameters(TLMoments(x), "gev"), c(.9, .95, .99))
est_cov(q) # default parametric
est_cov(q, np.cov = TRUE) # explicit non-parametric

q <- quantiles(parameters(TLMoments(c(rep(NA, 1000), x), na.rm = TRUE), "gev"), c(.9, .95, .99))
est_cov(q)

q <- quantiles(parameters(TLMoments(x, rightrim = 1), "gev"), c(.9, .95, .99))
est_cov(q) # default parametric
est_cov(q, np.cov = TRUE) # explicit non-parametric

x <- evd::rgev(1000, shape = .1)
q <- quantiles(parameters(TLMoments(x), "gev"), c(.9, .95, .99))
est_cov(q) # default parametric
est_cov(q, np.cov = TRUE) # explicit non-parametric

q <- quantiles(as.parameters(loc = 10, scale = 5, shape = .3, distr = "gev"), c(.9, .99))
est_cov(q)
est_cov(q, leftrim = 0, rightrim = 1)
est_cov(q, leftrim = 0, rightrim = 1, set.n = 100)

}

