% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLMoment.R
\name{TLMoment}
\alias{TLMoment}
\title{Trimmed L Moment.}
\usage{
TLMoment(x, order = 1L, leftrim = 0L, rightrim = 0L, na.rm = FALSE,
  computation.method = "auto")
}
\arguments{
\item{x}{vector of data}

\item{order}{integer, order of Trimmed Moment, has to be greater than 1}

\item{leftrim, rightrim}{integer indicating trimming parameters, have to be greater than 0}

\item{na.rm}{logical, indicates if NAs should be removed}

\item{computation.method}{character, indicating if the computation is performed via
PWMs, direct, recursive, or recurrence (see References Hosking & Balakrishnan, 2015).
Possible values are \code{auto} (default, automatically choose appropriate method), \code{pwm},
\code{direct}, \code{recursive}, or \code{recurrence}. Only if empirical moments are calculated.}
}
\value{
numeric, the TL(\code{leftrim},\code{rightrim})-moments of orders \code{order} of \code{x}
}
\description{
Calculates Trimmed L-moments of specific order(s) and trimming.
}
\examples{
x <- rnorm(100)
TLMoment(x, order = 1)
TLMoment(x, order = 2, leftrim = 0, rightrim = 1)
TLMoment(x, order = c(1, 2, 3), leftrim = 2, rightrim = 2)
TLMoment(x, order = c(1, 3, 2), leftrim = 2, rightrim = 2)
}
\references{
Elamir, E. A., & Seheult, A. H. (2003). Trimmed L-moments. Computational Statistics & Data Analysis, 43(3), 299-314.

Hosking, J. R. (1990). L-moments: analysis and estimation of distributions using linear combinations of order statistics. Journal of the Royal Statistical Society. Series B (Methodological), 105-124.

Hosking, J. R. M. (2007). Some theory and practical uses of trimmed L-moments. Journal of Statistical Planning and Inference, 137(9), 3024-3039.

Hosking, J. R. M., & Balakrishnan, N. (2015). A uniqueness result for L-estimators, with applications to L-moments. Statistical Methodology, 24, 69-80.
}
\seealso{
\code{\link{TLMoments}}
}
