% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_TL.plateau.R
\name{analyse_TL.plateau}
\alias{analyse_TL.plateau}
\title{Plateau test function for TL dating}
\usage{
analyse_TL.plateau(object, plotting.parameters = list(plot.Tmin = 0, plot.Tmax
  = NA, plateau.Tmin = 0, plateau.Tmax = NA, no.plot = FALSE))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the TL curves used for the Plateau test.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
The results are plotted using \link{plot_TL.plateau}. \cr
}
\description{
This function performs the plateau test for TL curves (Ln/Lx).
}
\details{
\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lowest temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Highest temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{plot_TL.plateau}. \cr
}
\author{
David Strebler, University of Cologne (Germany)
}
\references{
Aitken, M.J. (1985) Thermoluminescence Dating, Academic Press, London \cr
}
\seealso{
\link{calc_TL.LxTx},
 \link{calc_TL.plateau},
 \link{analyse_TL.MAAD}
}

