% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_substract.background.R
\name{mod_substract.background}
\alias{mod_substract.background}
\title{Creates a new TLum.Analysis object where the background was removed from the signal.}
\usage{
mod_substract.background(object, keep.background = FALSE,
  plotting.parameters = list(no.plot = FALSE))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the initial TL curves.}

\item{keep.background}{\link{logical} (with default): Parameter indicating if the background curve have to be kept or suppressed.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\value{
This function provides a new \code{\linkS4class{TLum.Analysis}} object with the TL curves after background subtraction. \cr
 It also plots the TL curves, the background curves and the background substracted curves using \link{plot_remove.preheat}.
}
\description{
Creates a new TLum.Analysis object where the background was removed from the signal.
}
\details{
\bold{Plotting parameters} \cr
 The plotting parameters are:  \cr
 \describe{
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{plot_substract.background}
}

