% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script_TL.export.R
\name{script_TL.export}
\alias{script_TL.export}
\title{Script for data export}
\usage{
script_TL.export(object, file.name, file.parameters = list(file.extension =
  ".binx", folder.out = "./"))
}
\arguments{
\item{object}{\code{\linkS4class{TLum.Analysis}} (\bold{required}): object containing the TL curves to export.}

\item{file.name}{\link{character} (\bold{required}): Name of the file containing the luminescence data.}

\item{file.parameters}{\link{list} (with default): list containing the file parameters. See details.


\bold{File parameters} \cr
The file parameters are:  \cr
\describe{
 \item{\code{file.extension}}{
   \link{character} (with default): extension of the file containing the luminescence data (.bin or .binx)}
 \item{\code{folder.out}}{
   \link{character} (with default): Folder containing the file with the luminescene data.}
}}
}
\value{
This function returns a \code{\linkS4class{TLum.Analysis}} object.
}
\description{
This script creates a .binx file from a \linkS4class{TLum.Analysis} object.
It just requires the name of the file and the \linkS4class{TLum.Analysis} object.
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{write_R2BIN},
 \link{TLum.BIN.File2Risoe.BINfileData},
 \link{TLum.Analysis2TLum.BIN.File}.
}

