% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical.Gaussian.MH.R
\name{tropical.Gaussian.MH}
\alias{tropical.Gaussian.MH}
\alias{trop.Gaussian.MH}
\alias{trop.Gaussian.MH.square}
\title{Gaussian-like sampling using Metropolis filter}
\usage{
trop.Gaussian.MH(D, x0, mu, s, n, I = 50)

trop.Gaussian.MH.square(D, x0, mu, s, n, I = 50)
}
\arguments{
\item{D}{matrix of vertices of a tropical polytope; each row is a vertex}

\item{x0}{initial point for sampler, numeric vector}

\item{mu}{location parameter; numeric vector}

\item{s}{scale parameter; scalar}

\item{n}{number of points to sample}

\item{I}{states in Markov chain}
}
\value{
matrix of n sampled points where each point is a row
}
\description{
This function samples points on a tropical line segment about a location parameter for a given scale parameter defined in terms of tropical distance
}
\examples{
D <-matrix(c(0,0,0,0,10,0,0,0,10),3,3,TRUE)
x0 <- c(0,0,0)
mu<-c(0,5,5)
s<-1
n<-10
trop.Gaussian.MH(D, x0, mu, s, n, I=50)
trop.Gaussian.MH.square(D, x0,mu, s, n, I=50)
}
\references{
Yoshida, Ruriko, Keiji Miura and David Barnhill (2022). Hit and Run Sampling from Tropically Convex Sets.
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
