% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical.HC.AGNES.R
\name{Tropical.HC.AGNES}
\alias{Tropical.HC.AGNES}
\title{Agglomerative (AGNES) tropical hierarchical clustering}
\usage{
Tropical.HC.AGNES(D, method = "average")
}
\arguments{
\item{D}{matrix of points defining a tropical polytope.  Rows are the tropical points}

\item{method}{linkage method: "average", "min", or "max"}
}
\value{
list of distances in when merges occur; list of indices of points in each cluster
}
\description{
This function performs agglomerative (AGNES) hierarchical clustering over the space of ultrametrics defining the space of equidistant trees
}
\examples{
\donttest{P <-Sim_points
Tropical.HC.AGNES(P, method="average")
}
}
\references{
David Barnhill, Ruriko Yoshida (2023). Clustering Methods Over the Tropically Convex Sets.
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
