% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOSTmeta.R
\name{TOSTmeta}
\alias{TOSTmeta}
\title{TOST function for meta-analysis}
\usage{
TOSTmeta(ES, var, se, low_eqbound_d, high_eqbound_d, alpha)
}
\arguments{
\item{ES}{meta-analytic effect size}

\item{var}{meta-analytic variance}

\item{se}{standard error}

\item{low_eqbound_d}{lower equivalence bounds (e.g., -0.5) expressed in standardized mean difference (Cohen's d)}

\item{high_eqbound_d}{upper equivalence bounds (e.g., 0.5) expressed in standardized mean difference (Cohen's d)}

\item{alpha}{alpha level (default = 0.05)}
}
\value{
Returns TOST Z-value 1, TOST p-value 1, TOST Z-value 2, TOST p-value 2,  alpha, low equivalence bound d, high equivalence bound d, Lower limit confidence interval TOST, Upper limit confidence interval TOST
}
\description{
TOST function for meta-analysis
}
\section{References}{

Rogers, J. L., Howard, K. I., & Vessey, J. T. (1993). Using significance tests to evaluate equivalence between two experimental groups. Psychological Bulletin, 113(3), 553, formula page 557.
}

\examples{
## Run TOSTmeta by specifying the standard error
TOSTmeta(ES=0.12, se=0.09, low_eqbound_d=-0.2, high_eqbound_d=0.2, alpha=0.05)
## Run TOSTmeta by specifying the variance
TOSTmeta(ES=0.12, var=0.0081, low_eqbound_d=-0.2, high_eqbound_d=0.2, alpha=0.05)
## If both variance and se are specified, TOSTmeta will use standard error and ignore variance
TOSTmeta(ES=0.12, var=9999, se = 0.09, low_eqbound_d=-0.2, high_eqbound_d=0.2, alpha=0.05)
}
