% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smd.R
\name{plot_smd}
\alias{plot_smd}
\title{plot_smd}
\usage{
plot_smd(
  d,
  df,
  lambda = NULL,
  sigma = NULL,
  smd_ci = c("goulet", "nct", "t", "z"),
  smd_label = "SMD",
  type = c("c", "cd"),
  levels = c(0.5, 0.9, 0.95, 0.999)
)
}
\arguments{
\item{d}{Estimate of the standardized mean difference}

\item{df}{degrees of freedom for the standardized mean difference}

\item{lambda}{The non-centrality parameter for the standardized mean difference}

\item{sigma}{The standard error for the standardized mean difference}

\item{smd_ci}{Method for calculating SMD confidence intervals. Methods include Goulet, noncentral t (nct), central t (t), and normal method (z).}

\item{smd_label}{Label for the x-axis indicating the SMD measure}

\item{type}{Choose whether to plot a "consonance" function ("c"), consonance density ("cd"), or both (c("c","cd"); defualt option).}

\item{levels}{Numeric vector of confidence levels to display}
}
\value{
Returns plot of the distribution of the standardized mean difference.
}
\description{
Function to produce plots of the distribution of the standardized mean difference
}
\details{
This function was created so that users could create plots from their own SMD calculations and were inspired by the concurve R package.
The difficulty is that specific information must be past onto this function.
The calculations for the standardized mean difference can be found in the vignettes of this package.
These types of plots are discussed by Schweder T, Hjort NL. (2016, ISBN:9781316445051) and Rafi Z, Greenland S. (2020) <doi:10.1186/s12874-020-01105-9>.
}
\seealso{
Other plotting functions: 
\code{\link{plot_cor}()},
\code{\link{plot_pes}()}
}
\concept{plotting functions}
