% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_split.R
\name{table_split}
\alias{table_split}
\title{Table split used for splitting a grouped column to multiple columns.}
\usage{
table_split(data, grouped_var = "variable", miss_drop = TRUE)
}
\arguments{
\item{data}{Dataframe: include columns (variables), rows (records).}

\item{grouped_var}{Character: grouped column name. Default: "variables".}

\item{miss_drop}{Logical: drop missing values or NA values. Default: TRUE, options: TRUE, FALSE.}
}
\value{
Table: table split used for splitting a grouped column to multiple columns.
}
\description{
Table split used for splitting a grouped column to multiple columns.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(table_split_data)
head(table_split_data)

# 3. Default parameters
res <- table_split(table_split_data)
head(res)

# 4. Set miss_drop = FALSE
res <- table_split(table_split_data, miss_drop = FALSE)
head(res)

}
\author{
benben-miao
}
