% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go_enrich_dot.R
\name{go_enrich_dot}
\alias{go_enrich_dot}
\title{GO enrichment analysis and dot plot (None/Exist Reference Genome).}
\usage{
go_enrich_dot(
  go_anno,
  degs_list,
  padjust_method = "fdr",
  pvalue_cutoff = 0.05,
  qvalue_cutoff = 0.05,
  sign_by = "p.adjust",
  category_num = 30,
  font_size = 12,
  low_color = "#ff0000aa",
  high_color = "#008800aa",
  ggTheme = "theme_light"
)
}
\arguments{
\item{go_anno}{Dataframe: GO and KEGG annotation of background genes (1st-col: Genes, 2nd-col: biological_process, 3rd-col: cellular_component, 4th-col: molecular_function, 5th-col: kegg_pathway).}

\item{degs_list}{Dataframe: degs list.}

\item{padjust_method}{Character: P-value adjust to Q-value. Default: "fdr" (false discovery rate), options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{pvalue_cutoff}{Numeric: P-value cutoff. Recommend: small than 0.05.}

\item{qvalue_cutoff}{Numeric: Q-value cutoff. Recommend: small than 0.05.}

\item{sign_by}{Character: significant by. Default: "p.adjust", options: "pvalue", "p.adjust", "qvalue".}

\item{category_num}{Numeric: categories number to display. Default: 30, min: 1, max: NULL.}

\item{font_size}{Numeric: category font size. Default: 12.}

\item{low_color}{Character: low value (p-value or q-value) color (color name or hex value).}

\item{high_color}{Character: high value (p-value or q-value) color (color name or hex value).}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void"}
}
\value{
Plot: GO enrichment analysis and dot plot (None/Exist Reference Genome).
}
\description{
GO enrichment analysis and dot plot (None/Exist Reference Genome).
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(gene_go_kegg)
head(gene_go_kegg)

# 3. Default parameters
go_enrich_dot(gene_go_kegg[,-5], gene_go_kegg[100:200,1])

# 4. Set padjust_method = "BH"
go_enrich_dot(gene_go_kegg[,-5], gene_go_kegg[100:200,1], padjust_method = "BH")

# 5. Set category_num = 10
go_enrich_dot(gene_go_kegg[,-5], gene_go_kegg[100:200,1], category_num = 10)

# 6. Set ggTheme = "theme_bw"
go_enrich_dot(gene_go_kegg[,-5], gene_go_kegg[100:200,1], ggTheme = "theme_bw")

}
\author{
benben-miao
}
