% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPRsim.R
\name{TPRsim}
\alias{TPRsim}
\title{Generate simulation data for tensor predictor regression (TPR)}
\usage{
TPRsim(p, r, u, n)
}
\arguments{
\item{p}{The dimension of predictor, a vector in the form of \eqn{(p_1,\cdots, p_m)}.}

\item{r}{The dimension of response, a scale.}

\item{u}{The structural dimension of envelopes at each mode, a vector with the same length as p.}

\item{n}{The sample size.}
}
\value{
\item{x}{The predictor of dimension \eqn{p_1\times \cdots\times p_m \times n}.}
\item{y}{The response of dimension \eqn{r\times n}.}
\item{Gamma}{A list of envelope subspace basis of dimension \eqn{p_k \times u_k, \ k=1,\ldots,m}.}
\item{coefficients}{The tensor coefficients of dimension \eqn{p_1\times \cdots\times p_m \times r}.}
\item{Sigma}{A lists of estimated covariance matrices at each mode for the tensor predictors, i.e., \eqn{\Sigma_1,\dots, \Sigma_m}.}
\item{p, r, u}{The input \code{p,r,u}.}
}
\description{
This function is used to generate simulation data used in tensor prediction regression.
}
\details{
The tensor predictor regression model is of the form,
\deqn{Y = B_{(m+1)}vec(X) + \epsilon}
where response \eqn{Y \in R^{r}}, predictor \eqn{X \in R^{p_1\times \cdots\times p_m}}, \eqn{B \in \in R^{p_1 \times\cdots\times p_m \times r}} and the error term is multivariate normal distributed. The predictor is tensor normal distributed,
\deqn{X\sim TN(0;\Sigma_1,\dots,\Sigma_m)}
According to the tensor envelope structure, we have
\deqn{B = [\Theta; \Gamma_1,\ldots, \Gamma_m, I_p],}
\deqn{\Sigma_k = \Gamma_k \Omega_k \Gamma_k^{T}+ \Gamma_{0k} \Omega_{0k} \Gamma_{0k}^T,}
for some \eqn{\Theta \in R^{u_1 \times\cdots\times u_m \times p}}, \eqn{\Omega_k \in R^{u_k \times u_k}} and \eqn{\Omega_{0k} \in \in R^{(p_k - u_k) \times (p_k - u_k)}}, \eqn{k=1,\ldots,m}.
}
\note{
The length of \code{p} must match that of \code{u}, and each element of \code{u} must be less than the corresponding element in \code{p}.
}
\examples{
p <- c(10, 10, 10)
u <- c(1, 1, 1)
r <- 5
n <- 200
dat <- TPRsim(p = p, r = r, u = u, n = n)
x <- dat$x
y <- dat$y
fit_std <- TPR.fit(x, y, method="standard")

}
\references{
Zhang, X. and Li, L., 2017. Tensor envelope partial least-squares regression. Technometrics, 59(4), pp.426-436.
}
\seealso{
\code{\link{TPR.fit}, \link{TRRsim}}.
}
