% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLSTM.R
\name{predict.LSTMModel}
\alias{predict.LSTMModel}
\title{Predict using a Trained LSTM Model}
\usage{
\method{predict}{LSTMModel}(
  object,
  ts,
  xreg = NULL,
  xreg.new = NULL,
  horizon = NULL,
  BatchSize = 1,
  ...
)
}
\arguments{
\item{object}{An LSTMModel object containing a trained LSTM model along with normalization parameters and lag values.}

\item{ts}{A vector or time series object containing the historical time series data. It should have a number of observations at least equal to the lag of the time series data.}

\item{xreg}{(Optional) A matrix or data frame of exogenous variables to be used for prediction. It should have a number of rows at least equal to the lag of the exogenous variables.}

\item{xreg.new}{(Optional) A matrix or data frame of exogenous variables to be used for prediction. It should have a number of rows at least equal to the lag of the exogenous variables.}

\item{horizon}{The number of future time steps to predict.}

\item{BatchSize}{Batch size to use during training}

\item{...}{Optional arguments, no use is contemplated right now}
}
\value{
A vector containing the forecasted values for the specified horizon.
}
\description{
This function makes predictions using a trained LSTM model for time series forecasting. It performs iterative predictions where each step uses the prediction from the previous step. The function takes into account the lags in both the time series data and the exogenous variables.
}
\examples{
\donttest{
  if (keras::is_keras_available()){
      y<-rnorm(100,mean=100,sd=50)
      x1<-rnorm(150,mean=50,sd=50)
      x2<-rnorm(150, mean=50, sd=25)
      x<-cbind(x1,x2)
      x.tr <- x[1:100,]
      x.ts <- x[101:150,]
      TSLSTM<-ts.lstm(ts=y,
                      xreg = x.tr,
                      tsLag=2,
                      xregLag = 0,
                      LSTMUnits=5,
                      ScaleInput = 'scale',
                      ScaleOutput = 'scale',
                      Epochs=2)
      current_values <- predict(TSLSTM, xreg = x.tr, ts = y)
      future_values <- predict(TSLSTM, horizon=50, xreg = x, ts = y, xreg.new = x.ts)
   }
}
}
