\name{EUNITE.Loads.cont}
\alias{EUNITE.Loads.cont}
\docType{data}
\title{Continuation dataset of the electrical loads of the EUNITE Competition
%%   ~~ data name/kind ... ~~
}
\description{A dataset of univariate time series providing 31 points beyond the end of the time series in \code{\link{EUNITE.Loads}} containing half-an-hour electrical loads measured in January 1999.
%%  ~~ A concise (1-5 lines) description of the dataset. ~~
}
\usage{data("EUNITE.Loads.cont")}
\format{
  A data frame with 31 observations on the following 48 variables.
  \describe{
    \item{\code{X00.30}}{a numeric vector containing further observations of \code{X00.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X01.00}}{a numeric vector containing further observations of \code{X01.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X01.30}}{a numeric vector containing further observations of \code{X01.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X02.00}}{a numeric vector containing further observations of \code{X02.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X02.30}}{a numeric vector containing further observations of \code{X02.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X03.00}}{a numeric vector containing further observations of \code{X03.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X03.30}}{a numeric vector containing further observations of \code{X03.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X04.00}}{a numeric vector containing further observations of \code{X04.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X04.30}}{a numeric vector containing further observations of \code{X04.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X05.00}}{a numeric vector containing further observations of \code{X05.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X05.30}}{a numeric vector containing further observations of \code{X05.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X06.00}}{a numeric vector containing further observations of \code{X06.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X06.30}}{a numeric vector containing further observations of \code{X06.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X07.00}}{a numeric vector containing further observations of \code{X07.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X07.30}}{a numeric vector containing further observations of \code{X07.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X08.00}}{a numeric vector containing further observations of \code{X08.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X08.30}}{a numeric vector containing further observations of \code{X08.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X09.00}}{a numeric vector containing further observations of \code{X09.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X09.30}}{a numeric vector containing further observations of \code{X09.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X10.00}}{a numeric vector containing further observations of \code{X10.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X10.30}}{a numeric vector containing further observations of \code{X10.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X11.00}}{a numeric vector containing further observations of \code{X11.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X11.30}}{a numeric vector containing further observations of \code{X11.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X12.00}}{a numeric vector containing further observations of \code{X12.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X12.30}}{a numeric vector containing further observations of \code{X12.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X13.00}}{a numeric vector containing further observations of \code{X13.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X13.30}}{a numeric vector containing further observations of \code{X13.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X14.00}}{a numeric vector containing further observations of \code{X14.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X14.30}}{a numeric vector containing further observations of \code{X14.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X15.00}}{a numeric vector containing further observations of \code{X15.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X15.30}}{a numeric vector containing further observations of \code{X15.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X16.00}}{a numeric vector containing further observations of \code{X16.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X16.30}}{a numeric vector containing further observations of \code{X16.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X17.00}}{a numeric vector containing further observations of \code{X17.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X17.30}}{a numeric vector containing further observations of \code{X17.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X18.00}}{a numeric vector containing further observations of \code{X18.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X18.30}}{a numeric vector containing further observations of \code{X18.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X19.00}}{a numeric vector containing further observations of \code{X19.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X19.30}}{a numeric vector containing further observations of \code{X19.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X20.00}}{a numeric vector containing further observations of \code{X20.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X20.30}}{a numeric vector containing further observations of \code{X20.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X21.00}}{a numeric vector containing further observations of \code{X21.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X21.30}}{a numeric vector containing further observations of \code{X21.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X22.00}}{a numeric vector containing further observations of \code{X22.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X22.30}}{a numeric vector containing further observations of \code{X22.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X23.00}}{a numeric vector containing further observations of \code{X23.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X23.30}}{a numeric vector containing further observations of \code{X23.30} in \code{\link{EUNITE.Loads}} relative to January 1999.}
    \item{\code{X24.00}}{a numeric vector containing further observations of \code{X24.00} in \code{\link{EUNITE.Loads}} relative to January 1999.}
  }
}
\details{Contains the 31 values corresponding to the daily maximum electrical loads of January 1999 which were to be predicted of \code{\link{EUNITE.Loads}} as demanded by the EUNITE Competition.
%%  ~~ If necessary, more details than the __description__ above ~~
}
\source{EUNITE 1999, Electricity Load Forecast using Intelligent Adaptive Technology: The EUNITE Network Competition. URL: \url{http://neuron.tuke.sk/competition/index.php}.
%%  ~~ reference to a publication or URL from which the data were obtained ~~
}
\references{B.-J. Chen, M.-W. Chang, and C.-J. Lin, 2004, Load forecasting using support vector Machines: a study on EUNITE competition 2001, IEEE Transactions on Power Systems, v. 19, n. 4 (Nov.), p. 1821-1830.
%%  ~~ possibly secondary sources and usages ~~
}
\seealso{\code{\link{EUNITE.Loads}}, \code{\link{EUNITE.Reg}}, \code{\link{EUNITE.Temp}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
data(EUNITE.Loads.cont)
str(EUNITE.Loads.cont)
plot(ts(EUNITE.Loads.cont["X24.00"]))
}
\keyword{datasets}
\keyword{EUNITE}
\keyword{Time Series}
\keyword{Competition}