% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SantaFe.D.r
\docType{data}
\name{SantaFe.D}
\alias{SantaFe.D}
\title{Time series D of the Santa Fe Time Series Competition}
\format{
A data frame with 100000 observations on the following variable.
\describe{ \item{V1}{a numeric vector containing the observations of
the univariate time series D of the Santa Fe Time Series Competition.} }
}
\usage{
SantaFe.D
}
\description{
A univariate computer-generated time series.
}
\details{
One of the benchmarks of the Santa Fe Time Series Competition, time series
D, is composed of a four-dimensional nonlinear time series with
non-stationary properties and 100,000 observations. Competitors were asked
to correctly predict the next 500 observations of this time series
(\code{\link{SantaFe.D.cont}}). The performance evaluation done by the Santa
Fe Competition was based on the NMSE errors of prediction found by the
competitors.
}
\examples{

data(SantaFe.D)
str(SantaFe.D)
plot(ts(SantaFe.D),xlim=c(1,2000))

}
\references{
A.S. Weigend, 1993, Time Series Prediction: Forecasting The
Future And Understanding The Past. Reading, MA, Westview Press.
}
\seealso{
\code{\link{SantaFe.D.cont}}, \code{\link{SantaFe.A}},
\code{\link{SantaFe.A.cont}} ~
}
\keyword{Competition}
\keyword{Fe}
\keyword{Santa}
\keyword{Series}
\keyword{Time}
\keyword{datasets}
