% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fittestEMD.r
\name{fittestEMD}
\alias{fittestEMD}
\title{Automatic prediction with empirical mode decomposition}
\usage{
fittestEMD(
  timeseries,
  timeseries.test = NULL,
  h = NULL,
  num_imfs = 0,
  S_number = 4L,
  num_siftings = 50L,
  level = 0.95,
  na.action = stats::na.omit,
  model = c("ets", "arima"),
  rank.by = c("MSE", "NMSE", "MAPE", "sMAPE", "MaxError", "errors")
)
}
\arguments{
\item{timeseries}{A vector or univariate time series.}

\item{timeseries.test}{A vector or univariate time series containing a
continuation for \code{timeseries} with actual values. It is used as a
testing set and base for calculation of prediction error measures. Ignored
if \code{NULL}.}

\item{h}{Number of consecutive values of the time series to be predicted. If
\code{h} is \code{NULL}, the number of consecutive values to be predicted is
assumed to be equal to the length of \code{timeseries.test}. Required when
\code{timeseries.test} is \code{NULL}.}

\item{num_imfs}{Number of Intrinsic Mode Functions (IMFs) to compute. See \code{\link[Rlibeemd]{emd}}.}

\item{S_number, num_siftings}{See \code{\link[Rlibeemd]{emd}}.}

\item{level}{Confidence level for prediction intervals. See
\code{\link[stats]{predict.lm}} and \code{\link[vars]{predict}}.}

\item{na.action}{A function for treating missing values in \code{timeseries}
and \code{timeseries.test}. The default function is \code{\link[stats]{na.omit}},
which omits any missing values found in \code{timeseries} or
\code{timeseries.test}.}

\item{model}{Character string. Indicates which model is to be used for
fitting and prediction of the components of the decomposed series.}

\item{rank.by}{Character string. Criteria used for ranking candidate
decompositions/models/predictions generated during parameter selection. See
'Details'.}
}
\value{
A list with components: \item{emd}{Same as \code{\link[Rlibeemd]{emd}}.
Contains the empirical mode decomposition of \code{timeseries}.}
\item{meaningfulImfs}{Character string indicating the automatically selected
meaningful IMFs of the decomposition.}
\item{pred}{A list with the
components \code{mean}, \code{lower} and \code{upper}, containing the
predictions based on the best evaluated decomposition and the lower and
upper limits for prediction intervals, respectively. All components are time
series.} \item{MSE}{Numeric value of the resulting MSE error of prediction.
Require \code{timeseries.test}.} \item{NMSE}{Numeric value of the resulting
NMSE error of prediction. Require \code{timeseries.test}.}
\item{MAPE}{Numeric value of the resulting MAPE error of prediction. Require
\code{timeseries.test}.} \item{sMAPE}{Numeric value of the resulting sMAPE
error of prediction. Require \code{timeseries.test}.}
\item{MaxError}{Numeric value of the maximal error of prediction. Require
\code{timeseries.test}.} \item{rank.val}{Data.frame with the fitness or
prediction accuracy criteria computed based on all candidate decompositions
ranked by \code{rank.by}.} \item{rank.by}{Ranking
criteria used for ranking candidate decompositions and producing
\code{rank.val}.}
}
\description{
The function automatically applies an empirical mode decomposition to a
provided univariate time series. The resulting components of the decomposed
series are used as base for predicting and returning the next n consecutive
values of the provided univariate time series using also automatically
fitted models. It also evaluates fitness and
prediction accuracy of the produced models.
}
\details{
The function produces an empirical mode decomposition of \code{timeseries}.
See the \code{\link[Rlibeemd]{emd}} function. The Intrinsic Mode Functions (IMFs) and residue series
resulting from the decomposition are separately used as base for model
fitting and prediction.
The set of predictions for all IMFs and residue series are then reversed
transformed in order to produce the next \code{h} consecutive values of the
provided univariate time series in \code{timeseries}. See the
\code{\link{emd.rev}} function.

The function automatically selects the meaningful IMFs of
a decomposition. For that, the function produces 
models for different selections of meaningful IMFs according to the
possible intervals \code{i:num_imfs} for \code{i=1,...,(num_imfs-1)}, where
\code{num_imfs} is the number of IMFs in a decomposition. The options of
meaningful IMFs of a decomposition which generate
the best ranked model fitness/predictions acoording to the criteria in
\code{rank.by} are selected.

The ranking criteria in \code{rank.by} may be set as a prediction error
measure (such as \code{\link{MSE}}, \code{\link{NMSE}}, \code{\link{MAPE}},
\code{\link{sMAPE}} or \code{\link{MAXError}}), or as a fitness criteria
(such as \code{\link{AIC}}, \code{\link{AICc}}, \code{\link{BIC}} or
\code{\link{logLik}}). In the former case, the candidate empirical mode
decompositions are used for time series prediction and the error measures
are calculated by means of a cross-validation process. In the latter case,
the component series of the candidate decompositions are modeled and model
fitness criteria are calculated based on all observations in
\code{timeseries}. In particular, the fitness criteria calculated for
ranking the candidate decompositions correspond to the
models produced for the IMFs.

If \code{rank.by} is set as \code{"errors"} or \code{"fitness"}, the
candidate decompositions are ranked by all the mentioned prediction error
measures or fitness criteria, respectively. The wheight of the ranking
criteria is equally distributed. In this case, a \code{rank.position.sum}
criterion is produced for ranking the candidate decompositions. The
\code{rank.position.sum} criterion is calculated as the sum of the rank
positions of a decomposition (1 = 1st position = better ranked model, 2 =
2nd position, etc.) on each calculated ranking criteria.
}
\examples{

data(CATS)
\donttest{
femd <- fittestEMD(CATS[,1],h=20)
}

}
\references{
Kim, D., Paek, S. H., & Oh, H. S. (2008). A Hilbert-Huang
transform approach for predicting cyber-attacks. Journal of the Korean
Statistical Society, 37(3), 277-283.
}
\seealso{
\code{\link{fittestWavelet}}, \code{\link{fittestMAS}}
}
\author{
Rebecca Pontes Salles
}
\keyword{adjustment}
\keyword{automatic}
\keyword{criterion}
\keyword{decomposition}
\keyword{emd}
\keyword{errors}
\keyword{evaluation}
\keyword{fitting}
\keyword{prediction}
\keyword{series}
\keyword{time}
\keyword{transform}
