\name{ngsim}
\alias{ngsim}

\title{Simulation by Non-Gaussian State Space Model}
\description{
  Simulation by non-Gaussian state space model.
}
\usage{
ngsim(n = 200, trend = NULL, seasonal.order = 0, seasonal = NULL, arcoef = NULL, 
      ar = NULL, noisew = 1, wminmax = NULL, paramw = NULL, noisev = 1,
      vminmax = NULL, paramv = NULL, seed = NULL, plot = TRUE, \dots)
}
\arguments{
  \item{n}{number of data generated by simulation.}
  \item{trend}{initial values of trend component of length \eqn{m1}, where
    \eqn{m1} is trend order (1, 2). If \code{NULL} (default), trend order is 0.}
  \item{seasonal.order}{order of seasonal component model (0, 1, 2).} 
  \item{seasonal}{if \code{seasonal.order} > 0, initial values of seasonal component
    of length \eqn{p-1}, where \eqn{p} is period of one season.}
  \item{arcoef}{AR coefficients.}
  \item{ar}{initial values of AR component.}
  \item{noisew}{type of the observational noise.
    \tabular{rl}{
      -1 : \tab Cauchy random number \cr
      -2 : \tab exponential distribution \cr
      -3 : \tab double exponential distribution \cr
       0 : \tab double exponential distribution (+ Euler's constant) \cr
       1 : \tab normal distribution (generated by inverse function) \cr
       2 : \tab Pearson distribution (generated by inverse function) \cr
       3 : \tab double exponential distribution (generated by inverse function)}
  }
  \item{wminmax}{lower and upper bound of observational noise.}
  \item{paramw}{parameter of the observational noise density.
    \tabular{rl}{
      noisew = 1 : \tab variance\cr
      noisew = 2 : \tab dispersion parameter (tau square) and shape parameter}
  }
  \item{noisev}{type of the system noise.
    \tabular{rl}{
      -1 : \tab Cauchy random number \cr
      -2 : \tab exponential distribution \cr
      -3 : \tab double exponential distribution \cr
       0 : \tab double exponential distribution (+ Euler's constant) \cr
       1 : \tab normal distribution (generated by inverse function) \cr
       2 : \tab Pearson distribution (generated by inverse function) \cr
       3 : \tab double exponential distribution (generated by inverse function)}
  }
  \item{vminmax}{lower and upper bound of system noise.}
  \item{paramv}{parameter of the system noise density.
    \tabular{rl}{
    noisev = 1 : \tab variance\cr
    noisev = 2 : \tab dispersion parameter (tau square) and shape parameter}
  }
  \item{seed}{arbitrary positive integer to generate a sequence of uniform
    random numbers. The default seed is based on the current time.}
  \item{plot}{logical. If \code{TRUE} (default), simulated data are plotted.}
  \item{\dots}{graphical arguments passed to \code{\link{plot.simulate}}.}
}
\value{
  An object of class \code{"simulate"}, giving simulated data of non-Gaussian
  state space model.
}
\references{
  Kitagawa, G. (2020)
  \emph{Introduction to Time Series Modeling with Applications in R}.
  Chapman & Hall/CRC.
}
\examples{
ar1 <- ngsim(n = 400, arcoef = 0.95, noisew = 1, paramw = 1, noisev = 1,
             paramv = 1, seed = 555)
plot(ar1, use = c(201, 400))

ar2 <- ngsim(n = 400, arcoef = c(1.3, -0.8), noisew = 1, paramw = 1, noisev = 1,
             paramv = 1, seed = 555)
plot(ar2, use = c(201, 400))


}

\keyword{ts}
