% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_functions.R
\name{create_model}
\alias{create_model}
\alias{add_input}
\alias{add_methods}
\alias{remove_methods}
\alias{add_train_method}
\alias{add_horizon}
\alias{build_model}
\alias{set_error}
\alias{add_xreg}
\alias{add_level}
\title{A Functional Approach for Building the \code{\link[TSstudio]{train_model}} Components}
\usage{
create_model()

add_input(model.obj, input)

add_methods(model.obj, methods)

remove_methods(model.obj, method_ids)

add_train_method(model.obj, train_method)

add_horizon(model.obj, horizon)

build_model(model.obj)

set_error(model.obj, error)

add_xreg(model.obj, xreg)

add_level(model.obj, level)
}
\arguments{
\item{model.obj}{The train_model skeleton, created by the create_model 
function or edited by add_input, add_methods, remove_methods, add_train_method or add_horizon}

\item{input}{A univariate time series object (ts class)}

\item{methods}{A list, defines the models to use for training and forecasting the series. 
The list must include a sub list with the model type, and the model's arguments (when applicable) and notes about the model. 
The sub-list name will be used as the model ID. Possible models:

\code{\link[stats]{arima}} - model from the stats package 

\code{\link[forecast]{auto.arima}} - model from the forecast package

\code{\link[forecast]{ets}} - model from the forecast package

 \code{\link[stats]{HoltWinters}} - model from the stats package 

\code{\link[forecast]{nnetar}} - model from the forecast package

\code{\link[forecast]{tslm}} - model from the forecast package (note that the 'tslm' model must have the formula argument in the 'method_arg' argument)}

\item{method_ids}{A character, defines the IDs of the model methods to be remove with the remove_methods function}

\item{train_method}{A list, defines the train approach, either using a single testing partition (sample out) 
or use multiple testing partitions (backtesting). The list should include the training method argument, (please see 'details' for the structure of the argument)}

\item{horizon}{An integer, defines the forecast horizon}

\item{error}{A character, defines the error metrics to be used to sort the models leaderboard. Possible metric - "MAPE" or "RMSE"}

\item{xreg}{Optional, a list with two vectors (e.g., data.frame or matrix) of external regressors, 
one vector corresponding to the input series and second to the forecast itself 
(e.g., must have the same length as the input and forecast horizon, respectively)}

\item{level}{An integer, set the  confidence level of the prediction intervals}
}
\description{
Add, edit, or remove the components of the  \code{\link[TSstudio]{train_model}} function
}
\examples{
 \dontrun{
### Building train_model function by adding its different components
# Create a skeleton model
md <- create_model()

class(md) 

# Add input
data(USgas)
md <- add_input(model.obj = md, input = USgas)

# Add methods
methods <- list(ets1 = list(method = "ets", 
                            method_arg = list(opt.crit = "lik"), 
                            notes = "ETS model with opt.crit = lik"),
                ets2 = list(method = "ets", 
                            method_arg = list(opt.crit = "amse"), 
                            notes = "ETS model with opt.crit = amse"),
                arima1 = list(method = "arima", 
                              method_arg = list(order = c(1,1,1), 
                                        seasonal = list(order = c(1,0,1))), 
                              notes = "SARIMA(1,1,1)(1,0,1)"))
                              
md <- add_methods(model.obj = md, methods = methods)   

# Add additional methods
methods2 <- list(arima2 = list(method = "arima", 
                              method_arg = list(order = c(2,1,2), 
                                     seasonal = list(order = c(1,1,1))), 
                              notes = "SARIMA(2,1,2)(1,1,1)"),
                hw = list(method = "HoltWinters", 
                          method_arg = NULL, 
                          notes = "HoltWinters Model"),
                tslm = list(method = "tslm", 
                    method_arg = list(formula = input ~ trend + season), 
                    notes = "tslm model with trend and seasonal components"))

md <- add_methods(model.obj = md, methods = methods2)

# Remove methods
md <- remove_methods(model.obj = md, method_ids = c("ets2"))  
  
# Add train method
md <- add_train_method(model.obj = md, train_method = list(partitions = 6, 
                                                       sample.out = 12, 
                                                       space = 3))
                                                       
                                                       
# Set the forecast horizon
md <- add_horizon(model.obj = md, horizon = 12)

# Add the forecast prediction intervals confidence level
md <- add_level(model.obj = md, level = c(90, 95))
                                                        
### Alternatively, pipe the function with the magrittr package  
                                                    
library(magrittr)

md <- create_model() \%>\%
      add_input(input = USgas) \%>\%
      add_methods(methods = methods) \%>\%
      add_methods(methods = methods2) \%>\%
      add_train_method(train_method = list(partitions = 4, 
                                           sample.out = 12, 
                                           space = 3)) \%>\%
       add_horizon(horizon = 12) \%>\%
       add_level(level = c(90, 95))
       
# Run the model
fc <- md \%>\% build_model()  
}
}
