% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T2Boot.R
\name{T2Boot}
\alias{T2Boot}
\title{The parametric bootstrap T2 test (T2Boot).}
\usage{
T2Boot(X, mu0, B)
}
\arguments{
\item{X}{a matrix n x p containing n observations and p variables. It should not contain missing values (NA).}

\item{mu0}{a vector containing the mean population to be tested.}

\item{B}{the number of resamples bootstrap parametric which must be at least equal to 2000.}
}
\value{
the numerical value and the p-value of the test statistic.
}
\description{
The parametric bootstrap version of the traditional T2 test.
}
\examples{
set.seed(0)
library(MASS)
n <- 30
p <- 2
rho <- 0.9
delta <- 0.9
mu <- rep(0, times  = p)
Sigma <- (1 - rho) * diag(p) + rho * matrix(1, p, p)
mu0 <- rep(0.3271,times = p)
B=2000
X <- mvrnorm(n, mu, Sigma)
T2Boot(X=X, mu0=mu0, B=2000)

}
\references{
Henrique J. P. Alves & Daniel F. Ferreira (2019): Proposition of new alternative tests adapted to the traditional T2 test, Communications in Statistics - Simulation and Computation, DOI: 10.1080/03610918.2019.1693596
}
